/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.configuration.LifecycleHandler;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.lifecycle.LifecycleHandlerInvocationException;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.lifecycle.StartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecycleHandlerInspector {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LIFECYCLE_PHASE_ATTRIBUTE_NAME = "phase";

    public static void registerLifecycleHandlers(@Nonnull LifecycleRegistry lifecycleRegistry, @Nonnull Object component) {
        Objects.requireNonNull(lifecycleRegistry, "Cannot register lifecycle handlers on a null lifecycle operator.");
        Objects.requireNonNull(component, "Cannot register lifecycle handlers from a null component.");
        if (component instanceof Lifecycle) {
            Lifecycle lifecycleAwareComponent = (Lifecycle)component;
            lifecycleAwareComponent.registerLifecycleHandlers(lifecycleRegistry);
        } else {
            LifecycleHandlerInspector.registerLifecycleHandlers(lifecycleRegistry, component, StartHandler.class, LifecycleRegistry::onStart);
            LifecycleHandlerInspector.registerLifecycleHandlers(lifecycleRegistry, component, ShutdownHandler.class, LifecycleRegistry::onShutdown);
        }
    }

    private static void registerLifecycleHandlers(LifecycleRegistry registry, Object component, Class<? extends Annotation> lifecycleAnnotation, LifecycleRegistration registrationMethod) {
        for (Method method : ReflectionUtils.methodsOf(component.getClass())) {
            AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, lifecycleAnnotation).ifPresent(lifecycleAnnotationAttributes -> {
                if (method.getParameterCount() > 0) {
                    throw new AxonConfigurationException(String.format("The @%s annotated method [%s] should not contain any parameters as none are allowed on lifecycle handlers", lifecycleAnnotation.getSimpleName(), method));
                }
                int phase = (Integer)lifecycleAnnotationAttributes.get(LIFECYCLE_PHASE_ATTRIBUTE_NAME);
                LifecycleHandler lifecycleHandler = configuration -> LifecycleHandlerInspector.invokeAndReturn(component, method, lifecycleAnnotation.getSimpleName(), phase);
                registrationMethod.registerLifecycleHandler(registry, phase, lifecycleHandler);
                logger.debug("Found and registered a {} with phase [{}] from component [{}]", new Object[]{lifecycleAnnotation.getSimpleName(), phase, component.getClass().getSimpleName()});
            });
        }
    }

    private static CompletableFuture<?> invokeAndReturn(Object lifecycleComponent, Method lifecycleHandler, String handlerType, int phase) {
        try {
            logger.debug("Invoking {} from component [{}] in phase [{}]", new Object[]{handlerType, lifecycleComponent.getClass().getSimpleName(), phase});
            Object result = ReflectionUtils.invokeAndGetMethodValue(lifecycleHandler, lifecycleComponent);
            return result instanceof CompletableFuture ? (CompletableFuture)result : FutureUtils.emptyCompletedFuture();
        }
        catch (Exception e) {
            CompletableFuture exceptionallyCompletedFuture = new CompletableFuture();
            exceptionallyCompletedFuture.completeExceptionally(new LifecycleHandlerInvocationException(lifecycleHandler, lifecycleComponent, e));
            return exceptionallyCompletedFuture;
        }
    }

    private LifecycleHandlerInspector() {
    }

    @FunctionalInterface
    private static interface LifecycleRegistration {
        public void registerLifecycleHandler(LifecycleRegistry var1, int var2, LifecycleHandler var3);
    }
}

