/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.ComponentNotFoundException;

public interface Configuration
extends DescribableComponent {
    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type) {
        return this.getComponent(type, type.getSimpleName());
    }

    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type, @Nonnull String name) {
        return this.getOptionalComponent(type, name).orElseThrow(() -> new ComponentNotFoundException(type, name));
    }

    default public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type) {
        return this.getOptionalComponent(type, type.getSimpleName());
    }

    public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> var1, @Nonnull String var2);

    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type, @Nonnull Supplier<C> defaultImpl) {
        return this.getComponent(type, type.getSimpleName(), defaultImpl);
    }

    @Nonnull
    public <C> C getComponent(@Nonnull Class<C> var1, @Nonnull String var2, @Nonnull Supplier<C> var3);

    public List<Configuration> getModuleConfigurations();

    public Optional<Configuration> getModuleConfiguration(@Nonnull String var1);

    @Nullable
    public Configuration getParent();
}

