/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.DefaultComponentRegistry;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.OverridePolicy;

public interface ComponentRegistry
extends DescribableComponent {
    default public <C> ComponentRegistry registerComponent(@Nonnull Class<C> type, @Nonnull ComponentFactory<C> factory) {
        return this.registerComponent(ComponentDefinition.ofType(type).withFactory(factory));
    }

    default public <C> ComponentRegistry registerComponent(@Nonnull Class<C> type, @Nonnull String name, @Nonnull ComponentFactory<? extends C> factory) {
        return this.registerComponent(ComponentDefinition.ofTypeAndName(type, name).withFactory(factory));
    }

    public <C> ComponentRegistry registerComponent(@Nonnull ComponentDefinition<? extends C> var1);

    default public <C, D extends C> ComponentRegistry registerDecorator(@Nonnull Class<C> type, int order, @Nonnull ComponentDecorator<C, D> decorator) {
        return this.registerDecorator(DecoratorDefinition.forType(type).with(decorator).order(order));
    }

    default public <C, D extends C> ComponentRegistry registerDecorator(@Nonnull Class<C> type, @Nonnull String name, int order, @Nonnull ComponentDecorator<C, D> decorator) {
        return this.registerDecorator(DecoratorDefinition.forTypeAndName(type, name).with(decorator).order(order));
    }

    public <C> ComponentRegistry registerDecorator(@Nonnull DecoratorDefinition<C, ? extends C> var1);

    default public boolean hasComponent(@Nonnull Class<?> type) {
        return this.hasComponent(type, type.getSimpleName());
    }

    public boolean hasComponent(@Nonnull Class<?> var1, @Nonnull String var2);

    public ComponentRegistry registerEnhancer(@Nonnull ConfigurationEnhancer var1);

    public ComponentRegistry registerModule(@Nonnull Module var1);

    public ComponentRegistry setOverridePolicy(@Nonnull OverridePolicy var1);

    public DefaultComponentRegistry disableEnhancerScanning();

    public DefaultComponentRegistry disableEnhancer(Class<? extends ConfigurationEnhancer> var1);
}

