/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.axonframework.common.StringUtils;

public abstract class Assert {
    private Assert() {
    }

    public static void state(boolean state, Supplier<String> messageSupplier) {
        if (!state) {
            throw new IllegalStateException(messageSupplier.get());
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void isFalse(boolean expression, Supplier<String> messageSupplier) {
        if (expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void notNull(Object value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
    }

    public static <T> T nonNull(T value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
        return value;
    }

    public static <T, X extends Throwable> void assertThat(T value, Predicate<T> assertion, Supplier<? extends X> exceptionSupplier) throws X {
        if (!assertion.test(value)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T, X extends Throwable> void assertNonNull(T value, Supplier<? extends X> exceptionSupplier) throws X {
        Assert.assertThat(value, Objects::nonNull, exceptionSupplier);
    }

    public static void nonEmpty(String string, String exceptionMessage) {
        Assert.assertThat(string, StringUtils::nonEmptyOrNull, () -> new IllegalArgumentException(exceptionMessage));
    }

    public static void assertStrictPositive(int i, String exceptionMessage) {
        if (i > 0) {
            return;
        }
        throw new IllegalArgumentException(exceptionMessage);
    }

    public static void assertStrictPositive(long i, String exceptionMessage) {
        if (i > 0L) {
            return;
        }
        throw new IllegalArgumentException(exceptionMessage);
    }
}

