/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Serializer;

public class ResultDeserializingCommandGateway
implements CommandGateway {
    private final CommandGateway delegate;
    private final Serializer serializer;

    public ResultDeserializingCommandGateway(@Nonnull CommandGateway delegate, @Nonnull Serializer serializer) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate must not be null.");
        this.serializer = Objects.requireNonNull(serializer, "The serializer must not be null.");
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nullable ProcessingContext context) {
        return new SerializingCommandResult(this.serializer, this.delegate.send(command, context));
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nonnull MetaData metaData, @Nullable ProcessingContext context) {
        return new SerializingCommandResult(this.serializer, this.delegate.send(command, metaData, context));
    }

    private record SerializingCommandResult(Serializer serializer, CommandResult delegate) implements CommandResult
    {
        @Override
        public CompletableFuture<? extends Message<?>> getResultMessage() {
            return this.delegate.getResultMessage();
        }

        @Override
        public <R> CompletableFuture<R> resultAs(@Nonnull Class<R> type) {
            return ((CompletableFuture)this.delegate.getResultMessage().thenApply(Message::getPayload)).thenApply(payload -> this.serializer.convert(payload, type));
        }

        @Override
        public <R> CommandResult onSuccess(@Nonnull Class<R> resultType, @Nonnull BiConsumer<R, Message<?>> successHandler) {
            Objects.requireNonNull(successHandler, "The success handler must not be null.");
            this.delegate.getResultMessage().whenComplete((message, e) -> {
                if (e == null) {
                    successHandler.accept((Object)this.serializer.convert(message.getPayload(), resultType), (Message<?>)message);
                }
            });
            return this;
        }
    }
}

