/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.RoutingStrategy;

public enum UnresolvedRoutingKeyPolicy implements RoutingStrategy
{
    ERROR(command -> {
        throw new CommandDispatchException(String.format("The command [%s] does not contain a routing key.", command.type()));
    }),
    RANDOM_KEY(command -> Double.toHexString(Math.random())),
    STATIC_KEY(command -> "unresolved");

    private final Function<CommandMessage<?>, String> routingKeyResolver;

    private UnresolvedRoutingKeyPolicy(Function<CommandMessage<?>, String> routingKeyResolver) {
        this.routingKeyResolver = routingKeyResolver;
    }

    @Override
    public String getRoutingKey(@Nonnull CommandMessage<?> command) {
        return this.routingKeyResolver.apply(command);
    }
}

