/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MethodCommandHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        Optional optionalRoutingKey = original.attribute("CommandHandler.routingKey");
        Optional optionalCommandName = original.attribute("CommandHandler.commandName");
        return optionalRoutingKey.isPresent() && optionalCommandName.isPresent() ? new MethodCommandMessageHandlingMember(original, (String)optionalRoutingKey.get(), (String)optionalCommandName.get()) : original;
    }

    private static class MethodCommandMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements CommandMessageHandlingMember<T> {
        private final String commandName;
        private final boolean isFactoryHandler;
        private final String routingKey;

        private MethodCommandMessageHandlingMember(MessageHandlingMember<T> delegate, String routingKeyAttribute, String commandNameAttribute) {
            super(delegate);
            boolean factoryMethod;
            Executable executable = delegate.unwrap(Executable.class).orElseThrow(() -> new AxonConfigurationException("The @CommandHandler annotation must be put on an Executable (either directly or as Meta Annotation)"));
            this.routingKey = "".equals(routingKeyAttribute) ? null : routingKeyAttribute;
            this.commandName = "".equals(commandNameAttribute) ? delegate.payloadType().getName() : commandNameAttribute;
            boolean bl = factoryMethod = executable instanceof Method && Modifier.isStatic(executable.getModifiers());
            if (factoryMethod && !executable.getDeclaringClass().isAssignableFrom(((Method)executable).getReturnType())) {
                throw new AxonConfigurationException("static @CommandHandler methods must declare a return value which is equal to or a subclass of the declaring type");
            }
            this.isFactoryHandler = executable instanceof Constructor || factoryMethod;
        }

        @Override
        public boolean canHandle(@Nonnull Message<?> message, ProcessingContext processingContext) {
            return super.canHandle(message, processingContext) && this.commandName.equals(message.type().name());
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }

        @Override
        public String commandName() {
            return this.commandName;
        }

        @Override
        public boolean isFactoryHandler() {
            return this.isFactoryHandler;
        }
    }
}

