/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerSubscriptionException;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ProcessingLifecycleHandlerRegistrar;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCommandBus.class);
    private final List<ProcessingLifecycleHandlerRegistrar> processingLifecycleHandlerRegistrars;
    private final ConcurrentMap<QualifiedName, CommandHandler> subscriptions = new ConcurrentHashMap<QualifiedName, CommandHandler>();
    private final Executor worker;

    public SimpleCommandBus(ProcessingLifecycleHandlerRegistrar ... processingLifecycleHandlerRegistrars) {
        this((Executor)DirectExecutor.instance(), processingLifecycleHandlerRegistrars);
    }

    public SimpleCommandBus(@Nonnull Executor workerSupplier, ProcessingLifecycleHandlerRegistrar ... processingLifecycleHandlerRegistrars) {
        this(workerSupplier, Arrays.asList(processingLifecycleHandlerRegistrars));
    }

    public SimpleCommandBus(@Nonnull Executor workerSupplier, @Nonnull Collection<ProcessingLifecycleHandlerRegistrar> processingLifecycleHandlerRegistrars) {
        this.worker = Objects.requireNonNull(workerSupplier, "The given Executor cannot be null.");
        this.processingLifecycleHandlerRegistrars = Objects.requireNonNull(processingLifecycleHandlerRegistrars).isEmpty() ? Collections.emptyList() : new ArrayList<ProcessingLifecycleHandlerRegistrar>(processingLifecycleHandlerRegistrars);
    }

    @Override
    public SimpleCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        CommandHandler handler = Objects.requireNonNull(commandHandler, "Given command handler cannot be null.");
        logger.debug("Subscribing command with name [{}].", (Object)name);
        CommandHandler existingHandler = this.subscriptions.putIfAbsent(Objects.requireNonNull(name, "The command name cannot be null."), handler);
        if (existingHandler != null && existingHandler != handler) {
            throw new DuplicateCommandHandlerSubscriptionException(name, existingHandler, handler);
        }
        return this;
    }

    @Override
    public CompletableFuture<? extends Message<?>> dispatch(@Nonnull CommandMessage<?> command, @Nullable ProcessingContext processingContext) {
        return this.findCommandHandlerFor(command).map(handler -> this.handle(command, (CommandHandler)handler)).orElseGet(() -> CompletableFuture.failedFuture(new NoHandlerForCommandException(String.format("No handler was subscribed for command [%s].", command.type()))));
    }

    private Optional<CommandHandler> findCommandHandlerFor(CommandMessage<?> command) {
        return Optional.ofNullable((CommandHandler)this.subscriptions.get(command.type().qualifiedName()));
    }

    protected CompletableFuture<? extends Message<?>> handle(@Nonnull CommandMessage<?> command, @Nonnull CommandHandler handler) {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling command [{} ({})]", (Object)command.getIdentifier(), (Object)command.type());
        }
        UnitOfWork unitOfWork = new UnitOfWork(command.getIdentifier(), this.worker);
        this.processingLifecycleHandlerRegistrars.forEach(it -> it.registerHandlers(unitOfWork));
        CompletionStage<Object> result = unitOfWork.executeWithResult(c -> handler.handle(command, (ProcessingContext)c).first().asCompletableFuture());
        if (logger.isDebugEnabled()) {
            result = result.whenComplete((r, e) -> {
                if (e == null) {
                    logger.debug("Command [{} ({})] completed successfully", (Object)command.getIdentifier(), (Object)command.type());
                } else {
                    logger.debug("Command [{} ({})] completed exceptionally", new Object[]{command.getIdentifier(), command.type(), e});
                }
            });
        }
        return result.thenApply(e -> e == null ? null : (CommandResultMessage)e.message());
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("lifecycleRegistrars", this.processingLifecycleHandlerRegistrars);
        descriptor.describeProperty("worker", this.worker);
        descriptor.describeProperty("subscriptions", this.subscriptions);
    }
}

