/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.Cache;

public abstract class AbstractCacheAdapter<L>
implements Cache {
    private final ConcurrentMap<Cache.EntryListener, L> registeredAdapters = new ConcurrentHashMap<Cache.EntryListener, L>();

    protected abstract L createListenerAdapter(Cache.EntryListener var1);

    @Override
    public Registration registerCacheEntryListener(Cache.EntryListener entryListener) {
        L adapter = this.createListenerAdapter(entryListener);
        Registration registration = this.registeredAdapters.putIfAbsent(entryListener, adapter) == null ? this.doRegisterListener(adapter) : null;
        return () -> {
            Object removedAdapter = this.registeredAdapters.remove(entryListener);
            if (removedAdapter != null) {
                if (registration != null) {
                    registration.cancel();
                }
                return true;
            }
            return false;
        };
    }

    protected abstract Registration doRegisterListener(L var1);
}

