/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.AbstractRetryScheduler;
import org.axonframework.common.BuilderUtils;

public class IntervalRetryScheduler
extends AbstractRetryScheduler {
    private static final long DEFAULT_RETRY_INTERVAL = 100L;
    private final long retryInterval;

    protected IntervalRetryScheduler(Builder builder) {
        super(builder);
        this.retryInterval = builder.retryInterval;
    }

    @Override
    protected long computeRetryInterval(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures) {
        return this.retryInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRetryScheduler.Builder<Builder> {
        private long retryInterval = 100L;

        public Builder retryInterval(int retryInterval) {
            BuilderUtils.assertPositive(retryInterval, "The retryInterval must be a positive number");
            this.retryInterval = retryInterval;
            return this;
        }

        public IntervalRetryScheduler build() {
            return new IntervalRetryScheduler(this);
        }
    }
}

