/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessingContext<T extends Message<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessingContext.class);
    private static final Deque EMPTY = new LinkedList();
    private final EnumMap<UnitOfWork.Phase, Deque<Consumer<UnitOfWork<T>>>> handlers = new EnumMap(UnitOfWork.Phase.class);
    private T message;
    private ExecutionResult executionResult;

    public MessageProcessingContext(T message) {
        this.message = message;
    }

    public void notifyHandlers(UnitOfWork<T> unitOfWork, UnitOfWork.Phase phase) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Notifying handlers for phase {}", (Object)phase.toString());
        }
        Deque l = this.handlers.getOrDefault((Object)phase, EMPTY);
        while (!l.isEmpty()) {
            try {
                ((Consumer)l.remove()).accept(unitOfWork);
            }
            catch (Exception e) {
                if (phase.isSuppressHandlerErrors()) {
                    LOGGER.info("An error occurred while executing a lifecycle phase handler for phase {}", (Object)phase, (Object)e);
                    continue;
                }
                throw e;
            }
        }
    }

    public void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding handler {} for phase {}", (Object)handler.getClass().getName(), (Object)phase.toString());
        }
        Deque consumers = this.handlers.computeIfAbsent(phase, p -> new ArrayDeque());
        if (phase.isReverseCallbackOrder()) {
            consumers.addFirst(handler);
        } else {
            consumers.add(handler);
        }
    }

    public void setExecutionResult(ExecutionResult executionResult) {
        Assert.state(this.executionResult == null || executionResult.isExceptionResult(), () -> String.format("Cannot change execution result [%s] to [%s] for message [%s].", this.executionResult, executionResult, this.message));
        if (this.executionResult != null && this.executionResult.isExceptionResult()) {
            this.executionResult.getExceptionResult().addSuppressed(executionResult.getExceptionResult());
        } else {
            this.executionResult = executionResult;
        }
    }

    public T getMessage() {
        return this.message;
    }

    public ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public void transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.message = transformOperator.apply(this.message);
    }

    public void reset(T message) {
        this.message = message;
        this.handlers.clear();
        this.executionResult = null;
    }
}

