/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.util.Objects;
import java.util.function.Function;
import org.axonframework.common.BuilderUtils;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.SingleEventUpcaster;

public class EventTypeUpcaster
extends SingleEventUpcaster {
    private final String expectedPayloadType;
    private final String expectedRevision;
    private final String upcastedPayloadType;
    private final String upcastedRevision;

    public static Builder from(Class<?> payloadType, String revision) {
        BuilderUtils.assertNonNull(payloadType, "The payloadType may not be null");
        return EventTypeUpcaster.from(payloadType.getName(), revision);
    }

    public static Builder from(String payloadType, String revision) {
        BuilderUtils.assertNonEmpty(payloadType, "The payloadType may not be null or empty");
        return new Builder(payloadType, revision);
    }

    public EventTypeUpcaster(String expectedPayloadType, String expectedRevision, String upcastedPayloadType, String upcastedRevision) {
        this.expectedPayloadType = expectedPayloadType;
        this.expectedRevision = expectedRevision;
        this.upcastedPayloadType = upcastedPayloadType;
        this.upcastedRevision = upcastedRevision;
    }

    @Override
    protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
        SerializedType serializedType = intermediateRepresentation.getType();
        return this.isExpectedPayloadType(serializedType.getName()) && this.isExpectedRevision(serializedType.getRevision());
    }

    protected boolean isExpectedPayloadType(String payloadType) {
        return Objects.equals(payloadType, this.expectedPayloadType);
    }

    protected boolean isExpectedRevision(String revision) {
        return Objects.equals(revision, this.expectedRevision);
    }

    @Override
    protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
        return intermediateRepresentation.upcastPayload(this.upcastedType(), Object.class, Function.identity());
    }

    protected SerializedType upcastedType() {
        return new SimpleSerializedType(this.upcastedPayloadType, this.upcastedRevision);
    }

    public static class Builder {
        private final String expectedPayloadType;
        private final String expectedRevision;

        public Builder(String expectedPayloadType, String expectedRevision) {
            this.expectedPayloadType = expectedPayloadType;
            this.expectedRevision = expectedRevision;
        }

        public EventTypeUpcaster to(Class<?> payloadType, String revision) {
            BuilderUtils.assertNonNull(payloadType, "The payloadType may not be null");
            return this.to(payloadType.getName(), revision);
        }

        public EventTypeUpcaster to(String payloadType, String revision) {
            BuilderUtils.assertNonEmpty(payloadType, "The payloadType may not be null or empty");
            return new EventTypeUpcaster(this.expectedPayloadType, this.expectedRevision, payloadType, revision);
        }
    }
}

