/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.serialization.SerializedObject;

public abstract class Headers {
    public static final String MESSAGE_ID = "axon-message-id";
    public static final String SERIALIZED_MESSAGE_PAYLOAD = "axon-serialized-message-payload";
    public static final String MESSAGE_TYPE = "axon-message-type";
    public static final String MESSAGE_REVISION = "axon-message-revision";
    public static final String MESSAGE_TIMESTAMP = "axon-message-timestamp";
    public static final String AGGREGATE_ID = "axon-message-aggregate-id";
    public static final String AGGREGATE_SEQ = "axon-message-aggregate-seq";
    public static final String AGGREGATE_TYPE = "axon-message-aggregate-type";
    public static final String MESSAGE_METADATA = "axon-metadata";
    public static final String DEADLINE_NAME = "axon-deadline-name";

    private Headers() {
    }

    public static Map<String, Object> defaultHeaders(EventMessage<?> message, SerializedObject<?> serializedObject) {
        Assert.notNull(message, () -> "Event message cannot be null");
        Assert.notNull(serializedObject, () -> "Serialized Object cannot be null");
        Assert.notNull(serializedObject.getType(), () -> "SerializedObject Type cannot be null");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(MESSAGE_ID, message.getIdentifier());
        headers.put(MESSAGE_TYPE, serializedObject.getType().getName());
        headers.put(MESSAGE_REVISION, serializedObject.getType().getRevision());
        headers.put(MESSAGE_TIMESTAMP, message.getTimestamp());
        if (message instanceof DomainEventMessage) {
            headers.put(AGGREGATE_ID, ((DomainEventMessage)message).getAggregateIdentifier());
            headers.put(AGGREGATE_SEQ, ((DomainEventMessage)message).getSequenceNumber());
            headers.put(AGGREGATE_TYPE, ((DomainEventMessage)message).getType());
        }
        return Collections.unmodifiableMap(headers);
    }

    public String toString() {
        return "[Headers]";
    }
}

