/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.axonframework.common.AxonConfigurationException;

public abstract class AnnotationUtils {
    public static final boolean OVERRIDE_ONLY = true;
    public static final boolean ADD_ALL = false;

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotationPresent(element, annotationType.getName());
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, String annotationType) {
        return AnnotationUtils.findAnnotationAttributes(element, annotationType).isPresent();
    }

    public static Optional<Map<String, Object>> findAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotationAttributes(element, annotationType, false);
    }

    public static Optional<Map<String, Object>> findAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean overrideOnly) {
        return AnnotationUtils.findAnnotationAttributes(element, annotationType.getName(), overrideOnly);
    }

    public static Optional<Map<String, Object>> findAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotationUtils.findAnnotationAttributes(element, annotationName, false);
    }

    public static Optional<Map<String, Object>> findAnnotationAttributes(AnnotatedElement element, String annotationName, boolean overrideOnly) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Annotation ann = AnnotationUtils.getAnnotation(element, annotationName);
        boolean found = false;
        if (ann != null) {
            AnnotationUtils.collectAttributes(ann, attributes);
            found = true;
        } else {
            HashSet<String> visited = new HashSet<String>();
            for (Annotation metaAnn : element.getAnnotations()) {
                if (!AnnotationUtils.collectAnnotationAttributes(metaAnn.annotationType(), annotationName, visited, attributes, overrideOnly)) continue;
                found = true;
                AnnotationUtils.collectAttributes(metaAnn, attributes, overrideOnly);
            }
        }
        return found ? Optional.of(attributes) : Optional.empty();
    }

    public static <T> Optional<T> findAnnotationAttribute(AnnotatedElement element, Class<? extends Annotation> annotationType, String attributeName) {
        return AnnotationUtils.findAnnotationAttributes(element, annotationType.getName()).map(attributes -> attributes.get(attributeName)).map(attribute -> attribute);
    }

    private static boolean collectAnnotationAttributes(Class<? extends Annotation> target, String annotationType, Set<String> visited, Map<String, Object> attributes, boolean overrideOnly) {
        Annotation ann = AnnotationUtils.getAnnotation(target, annotationType);
        if (ann == null && visited.add(target.getName())) {
            for (Annotation metaAnn : target.getAnnotations()) {
                if (!AnnotationUtils.collectAnnotationAttributes(metaAnn.annotationType(), annotationType, visited, attributes, overrideOnly)) continue;
                AnnotationUtils.collectAttributes(metaAnn, attributes, overrideOnly);
                return true;
            }
        } else if (ann != null) {
            AnnotationUtils.collectAttributes(ann, attributes);
            return true;
        }
        return false;
    }

    private static Annotation getAnnotation(AnnotatedElement target, String annotationType) {
        for (Annotation annotation : target.getAnnotations()) {
            if (!annotationType.equals(annotation.annotationType().getName())) continue;
            return annotation;
        }
        return null;
    }

    private static <T extends Annotation> void collectAttributes(T ann, Map<String, Object> attributes) {
        AnnotationUtils.collectAttributes(ann, attributes, false);
    }

    private static <T extends Annotation> void collectAttributes(T ann, Map<String, Object> attributes, boolean overrideOnly) {
        Method[] methods;
        for (Method method : methods = ann.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            try {
                String key = AnnotationUtils.resolveName(method);
                Object value = method.invoke(ann, new Object[0]);
                if (overrideOnly) {
                    attributes.computeIfPresent(key, (k, v) -> value);
                    continue;
                }
                attributes.put(key, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AxonConfigurationException("Error while inspecting annotation values", e);
            }
        }
    }

    private static String resolveName(Method method) {
        if ("value".equals(method.getName())) {
            String simpleName = method.getDeclaringClass().getSimpleName();
            return simpleName.substring(0, 1).toLowerCase(Locale.ENGLISH).concat(simpleName.substring(1));
        }
        return method.getName();
    }

    public static boolean isAnnotatedWith(Class<? extends Annotation> target, Class<? extends Annotation> subject, Set<Class<? extends Annotation>> annotatedWithSubject, Set<Class<? extends Annotation>> visited) {
        boolean hasSubjectAnnotation = false;
        for (Annotation metaAnnotation : target.getAnnotations()) {
            if (!subject.isAssignableFrom(metaAnnotation.annotationType())) continue;
            annotatedWithSubject.add(target);
            hasSubjectAnnotation = true;
        }
        if (visited.add(target)) {
            for (Annotation metaAnnotation : target.getAnnotations()) {
                if (!AnnotationUtils.isAnnotatedWith(metaAnnotation.annotationType(), subject, annotatedWithSubject, visited)) continue;
                annotatedWithSubject.add(target);
                hasSubjectAnnotation = true;
            }
        }
        return hasSubjectAnnotation;
    }

    private AnnotationUtils() {
    }
}

