/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.monitoring.MessageMonitor;

public class AsynchronousCommandBus
extends SimpleCommandBus {
    private final Executor executor;

    protected AsynchronousCommandBus(Builder builder) {
        super(builder);
        this.executor = builder.executor;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected <C, R> void handle(CommandMessage<C> command, MessageHandler<? super CommandMessage<?>> handler, CommandCallback<? super C, ? super R> callback) {
        this.executor.execute(() -> super.handle(command, handler, callback));
    }

    public void shutdown() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
            try {
                ((ExecutorService)this.executor).awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class Builder
    extends SimpleCommandBus.Builder {
        private Executor executor = Executors.newCachedThreadPool(new AxonThreadFactory(AsynchronousCommandBus.class.getSimpleName()));

        @Override
        public Builder transactionManager(TransactionManager transactionManager) {
            super.transactionManager(transactionManager);
            return this;
        }

        @Override
        public Builder messageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
            super.messageMonitor(messageMonitor);
            return this;
        }

        @Override
        public Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            super.rollbackConfiguration(rollbackConfiguration);
            return this;
        }

        @Override
        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            super.defaultCommandCallback(defaultCommandCallback);
            return this;
        }

        @Override
        public Builder duplicateCommandHandlerResolver(DuplicateCommandHandlerResolver duplicateCommandHandlerResolver) {
            super.duplicateCommandHandlerResolver(duplicateCommandHandlerResolver);
            return this;
        }

        public Builder executor(Executor executor) {
            BuilderUtils.assertNonNull(executor, "Executor may not be null");
            this.executor = executor;
            return this;
        }

        @Override
        public AsynchronousCommandBus build() {
            return new AsynchronousCommandBus(this);
        }
    }
}

