/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Assert;
import org.axonframework.common.MemberAccessibilityCallback;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.TypeReflectionUtils;

public abstract class ReflectionUtils {
    private static final Map<Type, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final String UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE = "Unsupported member type [%s]";
    public static final boolean RECURSIVE = true;
    public static final boolean NOT_RECURSIVE = false;

    public static <R> R getFieldValue(Field field, Object object) {
        ReflectionUtils.ensureAccessible(field);
        try {
            return (R)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("Unable to access field for getting.", ex);
        }
    }

    public static <T> void setFieldValue(Field field, Object object, T value) {
        ReflectionUtils.ensureAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unable to access field for setting.", ex);
        }
    }

    public static Class<?> declaringClass(Class<?> instanceClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return instanceClass.getMethod(methodName, parameterTypes).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasEqualsMethod(Class<?> type) {
        return !Object.class.equals(ReflectionUtils.declaringClass(type, "equals", Object.class));
    }

    public static boolean explicitlyUnequal(Object value, Object otherValue) {
        if (value == otherValue) {
            return false;
        }
        if (value == null || otherValue == null) {
            return true;
        }
        if (value instanceof Comparable) {
            return ((Comparable)value).compareTo(otherValue) != 0;
        }
        if (ReflectionUtils.hasEqualsMethod(value.getClass())) {
            return !value.equals(otherValue);
        }
        return false;
    }

    public static <T extends AccessibleObject> T ensureAccessible(T member) {
        if (!ReflectionUtils.isAccessible(member)) {
            AccessController.doPrivileged(new MemberAccessibilityCallback(member));
        }
        return member;
    }

    public static boolean isAccessible(AccessibleObject member) {
        return member.isAccessible() || member instanceof Member && ReflectionUtils.isNonFinalPublicMember((Member)((Object)member));
    }

    public static boolean isNonFinalPublicMember(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers()) && !Modifier.isFinal(member.getModifiers());
    }

    public static Iterable<Field> fieldsOf(Class<?> clazz) {
        return ReflectionUtils.fieldsOf(clazz, true);
    }

    public static Iterable<Field> fieldsOf(Class<?> clazz, boolean recursive) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Class<?> currentClazz = clazz;
        do {
            fields.addAll(Arrays.asList(currentClazz.getDeclaredFields()));
        } while ((currentClazz = currentClazz.getSuperclass()) != null && recursive);
        return Collections.unmodifiableList(fields);
    }

    public static Method methodOf(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterTypes);
    }

    public static Iterable<Method> methodsOf(Class<?> clazz) {
        return ReflectionUtils.methodsOf(clazz, true);
    }

    public static Iterable<Method> methodsOf(Class<?> clazz, boolean recursive) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Class<?> currentClazz = clazz;
        do {
            methods.addAll(Arrays.asList(currentClazz.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(currentClazz, methods);
        } while ((currentClazz = currentClazz.getSuperclass()) != null && recursive);
        return Collections.unmodifiableList(methods);
    }

    public static Class<?> resolvePrimitiveWrapperType(Class<?> primitiveType) {
        Assert.notNull(primitiveType, () -> "primitiveType may not be null");
        Assert.isTrue(primitiveType.isPrimitive(), () -> "primitiveType is not actually primitive: " + primitiveType);
        Class<?> primitiveWrapperType = primitiveWrapperTypeMap.get(primitiveType);
        Assert.notNull(primitiveWrapperType, () -> "no wrapper found for primitiveType: " + primitiveType);
        return primitiveWrapperType;
    }

    public static Type resolvePrimitiveWrapperTypeIfPrimitive(Type type) {
        Assert.notNull(type, () -> "type may not be null");
        return ObjectUtils.getOrDefault(primitiveWrapperTypeMap.get(type), type);
    }

    public static Type unwrapIfType(Type type, Class<?> ... wrapperTypes) {
        for (Class<?> wrapperType : wrapperTypes) {
            Type wrapper = TypeReflectionUtils.getExactSuperType(type, wrapperType);
            if (wrapper instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)wrapper).getActualTypeArguments();
                if (actualTypeArguments.length != 1) continue;
                return ReflectionUtils.unwrapIfType(actualTypeArguments[0], wrapperTypes);
            }
            if (!wrapperType.equals(type)) continue;
            return Object.class;
        }
        return type;
    }

    private static void addMethodsOnDeclaredInterfaces(Class<?> currentClazz, List<Method> methods) {
        for (Class<?> iface : currentClazz.getInterfaces()) {
            methods.addAll(Arrays.asList(iface.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(iface, methods);
        }
    }

    public static boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    public static Optional<Class<?>> resolveGenericType(Field field, int genericTypeIndex) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length <= genericTypeIndex) {
            return Optional.empty();
        }
        return Optional.of((Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex]);
    }

    public static Optional<Class<?>> resolveMemberGenericType(Member member, int genericTypeIndex) {
        Type genericType = ReflectionUtils.getMemberGenericType(member);
        if (!(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length <= genericTypeIndex) {
            return Optional.empty();
        }
        return Optional.of((Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex]);
    }

    public static <R> R invokeAndGetMethodValue(Method method, Object object) {
        ReflectionUtils.ensureAccessible(method);
        try {
            return (R)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to access method for invocation.", ex);
        }
    }

    public static <R> R getMemberValue(Member member, Object target) {
        if (member instanceof Field) {
            return ReflectionUtils.getFieldValue((Field)member, target);
        }
        if (member instanceof Method) {
            return ReflectionUtils.invokeAndGetMethodValue((Method)member, target);
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    public static Class<?> getMemberValueType(Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getReturnType();
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getType();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    public static Type getMemberGenericType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    public static String getMemberGenericString(Member member) {
        if (member instanceof Field) {
            return ((Field)member).toGenericString();
        }
        if (member instanceof Executable) {
            return ((Executable)member).toGenericString();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    private ReflectionUtils() {
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperTypeMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperTypeMap.put(Character.TYPE, Character.class);
        primitiveWrapperTypeMap.put(Double.TYPE, Double.class);
        primitiveWrapperTypeMap.put(Float.TYPE, Float.class);
        primitiveWrapperTypeMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperTypeMap.put(Long.TYPE, Long.class);
        primitiveWrapperTypeMap.put(Short.TYPE, Short.class);
    }
}

