/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.common.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryScheduler
implements RetryScheduler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_MAX_RETRIES = 1;
    private final ScheduledExecutorService retryExecutor;
    private final int maxRetryCount;

    protected AbstractRetryScheduler(Builder builder) {
        builder.validate();
        this.retryExecutor = builder.retryExecutor;
        this.maxRetryCount = builder.maxRetryCount;
    }

    protected boolean isExplicitlyNonTransient(Throwable failure) {
        return failure instanceof AxonNonTransientException || failure.getCause() != null && this.isExplicitlyNonTransient(failure.getCause());
    }

    protected boolean scheduleRetry(Runnable commandDispatch, long interval) {
        try {
            this.retryExecutor.schedule(commandDispatch, interval, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    protected abstract long computeRetryInterval(CommandMessage var1, RuntimeException var2, List<Class<? extends Throwable>[]> var3);

    @Override
    public boolean scheduleRetry(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures, Runnable dispatchTask) {
        int failureCount = failures.size();
        if (!this.isExplicitlyNonTransient(lastFailure) && failureCount <= this.maxRetryCount) {
            if (logger.isInfoEnabled()) {
                logger.info("Processing of Command [{}] resulted in an exception. Will retry {} more time(s)... Exception was {}, {}", new Object[]{commandMessage.getPayloadType().getSimpleName(), this.maxRetryCount - failureCount, lastFailure.getClass().getName(), lastFailure.getMessage()});
            }
            return this.scheduleRetry(dispatchTask, this.computeRetryInterval(commandMessage, lastFailure, failures));
        }
        if (failureCount >= this.maxRetryCount && logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception {} times. Giving up permanently. ", new Object[]{commandMessage.getPayloadType().getSimpleName(), failureCount, lastFailure});
        } else if (logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception and will not be retried. ", (Object)commandMessage.getPayloadType().getSimpleName(), (Object)lastFailure);
        }
        return false;
    }

    public static abstract class Builder<B extends Builder> {
        private ScheduledExecutorService retryExecutor;
        private int maxRetryCount = 1;

        public B retryExecutor(ScheduledExecutorService retryExecutor) {
            BuilderUtils.assertNonNull(retryExecutor, "ScheduledExecutorService may not be null");
            this.retryExecutor = retryExecutor;
            return (B)this;
        }

        public B maxRetryCount(int maxRetryCount) {
            BuilderUtils.assertStrictPositive(maxRetryCount, "The maxRetryCount must be a positive number");
            this.maxRetryCount = maxRetryCount;
            return (B)this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.retryExecutor, "The ScheduledExecutorService is a hard requirement and should be provided");
        }
    }
}

