/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.commandfilter;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.commandfilter.AndCommandMessageFilter;
import org.axonframework.commandhandling.distributed.commandfilter.OrCommandMessageFilter;

public class DenyCommandNameFilter
implements CommandMessageFilter {
    private final Set<String> commandNames;

    @ConstructorProperties(value={"commandNames"})
    public DenyCommandNameFilter(@JsonProperty(value="commandNames") Set<String> commandNames) {
        this.commandNames = new HashSet<String>(commandNames);
    }

    public DenyCommandNameFilter(String commandName) {
        this.commandNames = Collections.singleton(commandName);
    }

    @Override
    public boolean matches(CommandMessage<?> commandMessage) {
        return !this.commandNames.contains(commandMessage.getCommandName());
    }

    @Override
    public CommandMessageFilter and(CommandMessageFilter other) {
        if (other instanceof DenyCommandNameFilter) {
            return new DenyCommandNameFilter(Stream.concat(this.commandNames.stream(), ((DenyCommandNameFilter)other).commandNames.stream()).collect(Collectors.toSet()));
        }
        return new AndCommandMessageFilter(this, other);
    }

    @Override
    public CommandMessageFilter or(CommandMessageFilter other) {
        if (other instanceof DenyCommandNameFilter) {
            return new DenyCommandNameFilter(this.commandNames.stream().filter(((DenyCommandNameFilter)other).commandNames::contains).collect(Collectors.toSet()));
        }
        return new OrCommandMessageFilter(this, other);
    }

    @JsonGetter
    private Set<String> getCommandNames() {
        return this.commandNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenyCommandNameFilter that = (DenyCommandNameFilter)o;
        return Objects.equals(this.commandNames, that.commandNames);
    }

    public int hashCode() {
        return Objects.hash(this.commandNames);
    }

    public String toString() {
        return "DenyCommandNameFilter{commandNames=" + this.commandNames + '}';
    }
}

