/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ResetNotSupportedException;
import org.axonframework.eventhandling.replay.GenericResetContext;
import org.axonframework.eventhandling.replay.ResetContext;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotationEventHandlerAdapter
implements EventMessageHandler {
    private final AnnotatedHandlerInspector<Object> inspector;
    private final Class<?> listenerType;
    private final Object annotatedEventListener;

    public AnnotationEventHandlerAdapter(Object annotatedEventListener) {
        this(annotatedEventListener, ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass()));
    }

    public AnnotationEventHandlerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory) {
        this(annotatedEventListener, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedEventListener.getClass()));
    }

    public AnnotationEventHandlerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.annotatedEventListener = annotatedEventListener;
        this.listenerType = annotatedEventListener.getClass();
        this.inspector = AnnotatedHandlerInspector.inspectType(annotatedEventListener.getClass(), parameterResolverFactory, handlerDefinition);
    }

    @Override
    public Object handle(EventMessage<?> event) throws Exception {
        Optional<MessageHandlingMember> handler = this.inspector.getHandlers(this.listenerType).filter(h -> h.canHandle(event)).findFirst();
        if (handler.isPresent()) {
            MessageHandlerInterceptorMemberChain<Object> interceptor = this.inspector.chainedInterceptor(this.listenerType);
            return interceptor.handle(event, this.annotatedEventListener, handler.get());
        }
        return null;
    }

    @Override
    public boolean canHandle(EventMessage<?> event) {
        return this.inspector.getHandlers(this.listenerType).anyMatch(h -> h.canHandle(event));
    }

    @Override
    public boolean canHandleType(Class<?> payloadType) {
        return this.inspector.getHandlers(this.listenerType).filter(this::handlesEventMessage).anyMatch(handler -> handler.canHandleType(payloadType));
    }

    private boolean handlesEventMessage(MessageHandlingMember<? super Object> messageHandler) {
        return messageHandler.annotationAttributes(MessageHandler.class).map(attributes -> attributes.get("messageType")).map(messageType -> EventMessage.class.isAssignableFrom((Class)messageType)).orElse(false);
    }

    @Override
    public Class<?> getTargetType() {
        return this.listenerType;
    }

    @Override
    public void prepareReset() {
        this.prepareReset(null);
    }

    @Override
    public <R> void prepareReset(R resetContext) {
        try {
            ResetContext resetMessage = GenericResetContext.asResetContext(resetContext);
            Optional<MessageHandlingMember> handler = this.inspector.getHandlers(this.listenerType).filter(h -> h.canHandle(resetMessage)).findFirst();
            if (handler.isPresent()) {
                handler.get().handle(resetMessage, this.annotatedEventListener);
            }
        }
        catch (Exception e) {
            throw new ResetNotSupportedException("An Error occurred while notifying handlers of the reset", e);
        }
    }

    @Override
    public boolean supportsReset() {
        return true;
    }
}

