/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.LongStream;
import org.axonframework.common.Assert;
import org.axonframework.common.CollectionUtils;
import org.axonframework.eventhandling.TrackingToken;

public class GapAwareTrackingToken
implements TrackingToken,
Serializable {
    private static final long serialVersionUID = -3190388158060110593L;
    private final long index;
    private final SortedSet<Long> gaps;
    private final transient long gapTruncationIndex;

    public static GapAwareTrackingToken newInstance(long index, Collection<Long> gaps) {
        return new GapAwareTrackingToken(index, gaps);
    }

    @JsonCreator
    @ConstructorProperties(value={"index", "gaps"})
    public GapAwareTrackingToken(@JsonProperty(value="index") long index, @JsonProperty(value="gaps") Collection<Long> gaps) {
        this(index, GapAwareTrackingToken.createSortedSetOf(gaps, index), 0L);
    }

    private GapAwareTrackingToken(long index, SortedSet<Long> gaps, long gapTruncationIndex) {
        this.index = index;
        this.gaps = gaps;
        this.gapTruncationIndex = gapTruncationIndex;
    }

    protected static SortedSet<Long> createSortedSetOf(Collection<Long> gaps, long index) {
        if (gaps == null || gaps.isEmpty()) {
            return Collections.emptySortedSet();
        }
        ConcurrentSkipListSet<Long> gapSet = new ConcurrentSkipListSet<Long>(gaps);
        Assert.isTrue((Long)gapSet.last() < index, () -> String.format("Gap indices [%s] should all be smaller than head index [%d]", gaps, index));
        return gapSet;
    }

    public GapAwareTrackingToken advanceTo(long index, int maxGapOffset) {
        long newIndex;
        ConcurrentSkipListSet<Long> gaps = new ConcurrentSkipListSet<Long>(this.gaps);
        if (gaps.remove(index)) {
            newIndex = this.index;
        } else if (index > this.index) {
            newIndex = index;
            LongStream.range(this.index + 1L, index).forEach(gaps::add);
        } else {
            throw new IllegalArgumentException(String.format("The given index [%d] should be larger than the token index [%d] or be one of the token's gaps [%s]", index, this.index, gaps));
        }
        long smalledAllowedGap = Math.max(this.gapTruncationIndex, newIndex - (long)maxGapOffset);
        gaps.removeAll(gaps.headSet(smalledAllowedGap));
        return new GapAwareTrackingToken(newIndex, gaps, smalledAllowedGap);
    }

    public GapAwareTrackingToken withGapsTruncatedAt(long truncationPoint) {
        if (this.gaps.isEmpty() || this.gaps.first() > truncationPoint) {
            return this;
        }
        ConcurrentSkipListSet<Long> truncatedGaps = new ConcurrentSkipListSet<Long>(this.gaps.tailSet(truncationPoint));
        return new GapAwareTrackingToken(this.index, truncatedGaps, truncationPoint);
    }

    public long getIndex() {
        return this.index;
    }

    public SortedSet<Long> getGaps() {
        return Collections.unmodifiableSortedSet(this.gaps);
    }

    @Override
    public GapAwareTrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue(other instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        ConcurrentSkipListSet<Long> mergedGaps = new ConcurrentSkipListSet<Long>(this.gaps);
        mergedGaps.addAll(otherToken.gaps);
        long mergedIndex = this.calculateIndex(otherToken, mergedGaps);
        mergedGaps.removeIf(i -> i >= mergedIndex);
        return new GapAwareTrackingToken(mergedIndex, mergedGaps, Math.min(this.gapTruncationIndex, otherToken.gapTruncationIndex));
    }

    @Override
    public TrackingToken upperBound(TrackingToken otherToken) {
        Assert.isTrue(otherToken instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken other = (GapAwareTrackingToken)otherToken;
        SortedSet newGaps = CollectionUtils.intersect(this.gaps, other.gaps, ConcurrentSkipListSet::new);
        long min = Math.min(this.index, other.index) + 1L;
        SortedSet mergedGaps = CollectionUtils.merge(this.gaps.tailSet(min), other.gaps.tailSet(min), ConcurrentSkipListSet::new);
        newGaps.addAll(mergedGaps);
        return new GapAwareTrackingToken(Math.max(this.index, other.index), newGaps, Math.min(this.gapTruncationIndex, other.gapTruncationIndex));
    }

    private long calculateIndex(GapAwareTrackingToken otherToken, SortedSet<Long> mergedGaps) {
        long mergedIndex = Math.min(this.index, otherToken.index);
        while (mergedGaps.contains(mergedIndex)) {
            --mergedIndex;
        }
        return mergedIndex;
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue(other instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        if (!this.gaps.isEmpty() && !this.gaps.headSet(otherToken.gapTruncationIndex).isEmpty() && this.gapTruncationIndex < otherToken.gapTruncationIndex) {
            return this.withGapsTruncatedAt(otherToken.gapTruncationIndex).covers(other);
        }
        return otherToken.index <= this.index && !this.gaps.contains(otherToken.index) && otherToken.gaps.containsAll(this.gaps.headSet(otherToken.index));
    }

    public boolean hasGaps() {
        return !this.gaps.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GapAwareTrackingToken that = (GapAwareTrackingToken)o;
        long truncationIndex = Math.max(this.gapTruncationIndex, that.gapTruncationIndex) + 1L;
        return this.index == that.index && Objects.equals(this.gaps.tailSet(truncationIndex), that.gaps.tailSet(truncationIndex));
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return "GapAwareTrackingToken{index=" + this.index + ", gaps=" + this.gaps + '}';
    }

    @Override
    public OptionalLong position() {
        return OptionalLong.of(this.index);
    }
}

