/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.common.Assert;

public class AxonThreadFactory
implements ThreadFactory {
    private final int priority;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger();

    public AxonThreadFactory(String groupName) {
        this(new ThreadGroup(groupName));
    }

    public AxonThreadFactory(ThreadGroup group) {
        this(5, group);
    }

    public AxonThreadFactory(int priority, ThreadGroup group) {
        Assert.isTrue(priority <= 10 && priority >= 1, () -> "Given priority is invalid");
        this.priority = priority;
        this.threadGroup = group;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.threadGroup, r, this.threadGroup.getName() + "-" + this.nextThreadNumber());
        thread.setPriority(this.priority);
        return thread;
    }

    private int nextThreadNumber() {
        return this.threadNumber.getAndIncrement();
    }
}

