/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerComparator;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotatedHandlerInspector<T> {
    private final Class<T> inspectedType;
    private final ParameterResolverFactory parameterResolverFactory;
    private final Map<Class<?>, AnnotatedHandlerInspector> registry;
    private final List<AnnotatedHandlerInspector<? super T>> superClassInspectors;
    private final List<AnnotatedHandlerInspector<? extends T>> subClassInspectors;
    private final Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> handlers;
    private final HandlerDefinition handlerDefinition;

    private AnnotatedHandlerInspector(Class<T> inspectedType, List<AnnotatedHandlerInspector<? super T>> superClassInspectors, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry, List<AnnotatedHandlerInspector<? extends T>> subClassInspectors) {
        this.inspectedType = inspectedType;
        this.parameterResolverFactory = parameterResolverFactory;
        this.registry = registry;
        this.superClassInspectors = new ArrayList<AnnotatedHandlerInspector<T>>(superClassInspectors);
        this.handlers = new HashMap();
        this.handlerDefinition = handlerDefinition;
        this.subClassInspectors = subClassInspectors;
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType) {
        return AnnotatedHandlerInspector.inspectType(handlerType, ClasspathParameterResolverFactory.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType, ParameterResolverFactory parameterResolverFactory) {
        return AnnotatedHandlerInspector.inspectType(handlerType, parameterResolverFactory, ClasspathHandlerDefinition.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return AnnotatedHandlerInspector.inspectType(handlerType, parameterResolverFactory, handlerDefinition, Collections.emptySet());
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Set<Class<? extends T>> declaredSubtypes) {
        return AnnotatedHandlerInspector.createInspector(handlerType, parameterResolverFactory, handlerDefinition, new HashMap(), declaredSubtypes);
    }

    private static <T> AnnotatedHandlerInspector<T> createInspector(Class<? extends T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry, Set<Class<? extends T>> declaredSubtypes) {
        if (!registry.containsKey(inspectedType)) {
            registry.put(inspectedType, AnnotatedHandlerInspector.initialize(inspectedType, parameterResolverFactory, handlerDefinition, registry, declaredSubtypes));
        }
        return registry.get(inspectedType);
    }

    private static <T> AnnotatedHandlerInspector<T> initialize(Class<T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry, Set<Class<? extends T>> declaredSubtypes) {
        ArrayList<AnnotatedHandlerInspector<T>> parents = new ArrayList<AnnotatedHandlerInspector<T>>();
        for (Class<?> iFace : inspectedType.getInterfaces()) {
            parents.add(AnnotatedHandlerInspector.createInspector(iFace, parameterResolverFactory, handlerDefinition, registry, Collections.emptySet()));
        }
        if (inspectedType.getSuperclass() != null && !Object.class.equals(inspectedType.getSuperclass())) {
            parents.add(AnnotatedHandlerInspector.createInspector(inspectedType.getSuperclass(), parameterResolverFactory, handlerDefinition, registry, Collections.emptySet()));
        }
        List<AnnotatedHandlerInspector<? extends T>> children = declaredSubtypes.stream().map(subclass -> AnnotatedHandlerInspector.createInspector(subclass, parameterResolverFactory, handlerDefinition, registry, Collections.emptySet())).collect(Collectors.toList());
        AnnotatedHandlerInspector<? extends T> inspector = new AnnotatedHandlerInspector<T>(inspectedType, parents, parameterResolverFactory, handlerDefinition, registry, children);
        super.initializeMessageHandlers(parameterResolverFactory, handlerDefinition);
        return inspector;
    }

    private void initializeMessageHandlers(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.handlers.put(this.inspectedType, new TreeSet(HandlerComparator.instance()));
        for (Method method : this.inspectedType.getDeclaredMethods()) {
            handlerDefinition.createHandler(this.inspectedType, method, parameterResolverFactory).ifPresent(h -> this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h));
        }
        for (Executable executable : this.inspectedType.getDeclaredConstructors()) {
            handlerDefinition.createHandler(this.inspectedType, executable, parameterResolverFactory).ifPresent(h -> this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h));
        }
        this.subClassInspectors.forEach(sci -> sci.getAllHandlers().forEach((key, value) -> value.forEach(h -> this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h))));
        this.superClassInspectors.forEach(sci -> sci.getAllHandlers().forEach((key, value) -> value.forEach(h -> {
            this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h);
            this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h);
        })));
    }

    private void registerHandler(Class<?> type, MessageHandlingMember<? super T> handler) {
        this.handlers.compute(type, (key, value) -> {
            if (value == null) {
                TreeSet handlers = new TreeSet(HandlerComparator.instance());
                handlers.add(handler);
                return handlers;
            }
            value.add(handler);
            return value;
        });
    }

    public <C> AnnotatedHandlerInspector<C> inspect(Class<? extends C> entityType) {
        return AnnotatedHandlerInspector.createInspector(entityType, this.parameterResolverFactory, this.handlerDefinition, this.registry, Collections.emptySet());
    }

    @Deprecated
    public List<MessageHandlingMember<? super T>> getHandlers() {
        return this.getHandlers(this.inspectedType).collect(Collectors.toList());
    }

    public Stream<MessageHandlingMember<? super T>> getHandlers(Class<?> type) {
        return this.handlers.getOrDefault(type, Collections.emptySortedSet()).stream();
    }

    public Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> getAllHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }
}

