/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;

public abstract class AbstractEventGateway {
    private final EventBus eventBus;
    private final List<MessageDispatchInterceptor<? super EventMessage<?>>> dispatchInterceptors;

    protected AbstractEventGateway(Builder builder) {
        builder.validate();
        this.eventBus = builder.eventBus;
        this.dispatchInterceptors = builder.dispatchInterceptors;
    }

    protected void publish(Object event) {
        this.eventBus.publish(this.processInterceptors(GenericEventMessage.asEventMessage(event)));
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super EventMessage<?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    protected <E> EventMessage<? extends E> processInterceptors(EventMessage<E> eventMessage) {
        EventMessage<E> message = eventMessage;
        for (MessageDispatchInterceptor<EventMessage<?>> dispatchInterceptor : this.dispatchInterceptors) {
            message = dispatchInterceptor.handle(message);
        }
        return message;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public static abstract class Builder {
        private EventBus eventBus;
        private List<MessageDispatchInterceptor<? super EventMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();

        public Builder eventBus(EventBus eventBus) {
            BuilderUtils.assertNonNull(eventBus, "EventBus may not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder dispatchInterceptors(MessageDispatchInterceptor<? super EventMessage<?>> ... dispatchInterceptors) {
            return this.dispatchInterceptors(Arrays.asList(dispatchInterceptors));
        }

        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super EventMessage<?>>> dispatchInterceptors) {
            this.dispatchInterceptors = dispatchInterceptors != null && !dispatchInterceptors.isEmpty() ? new CopyOnWriteArrayList(dispatchInterceptors) : new CopyOnWriteArrayList();
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.eventBus, "The EventBus is a hard requirement and should be provided");
        }
    }
}

