/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import java.lang.reflect.Method;
import org.axonframework.common.property.BeanPropertyAccessStrategy;
import org.axonframework.common.property.MethodAccessedProperty;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMethodPropertyAccessStrategy
extends PropertyAccessStrategy {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyAccessStrategy.class);

    @Override
    public <T> Property<T> propertyFor(Class<? extends T> targetClass, String property) {
        String methodName = this.getterName(property);
        try {
            Method method = targetClass.getMethod(methodName, new Class[0]);
            if (!Void.TYPE.equals(method.getReturnType())) {
                return new MethodAccessedProperty(method, property);
            }
            logger.debug("Method with name '{}' in '{}' cannot be accepted as a property accessor, as it returns void", (Object)methodName, (Object)targetClass.getName());
        }
        catch (NoSuchMethodException e) {
            logger.debug("No method with name '{}' found in {} to use as property accessor. Attempting to fall back to other strategies.", (Object)methodName, (Object)targetClass.getName());
        }
        return null;
    }

    protected abstract String getterName(String var1);
}

