/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.axonframework.common.Assert;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.Cache;

public class WeakReferenceCache
implements Cache {
    private final ConcurrentMap<Object, Entry> cache = new ConcurrentHashMap<Object, Entry>();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final Set<Cache.EntryListener> adapters = new CopyOnWriteArraySet<Cache.EntryListener>();

    @Override
    public Registration registerCacheEntryListener(Cache.EntryListener entryListener) {
        this.adapters.add(entryListener);
        return () -> this.adapters.remove(entryListener);
    }

    @Override
    public <K, V> V get(K key) {
        V returnValue;
        Assert.nonNull(key, () -> "Key may not be null");
        this.purgeItems();
        Reference entry = (Reference)this.cache.get(key);
        V v = returnValue = entry == null ? null : (V)entry.get();
        if (returnValue != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRead(key, returnValue);
            }
        }
        return returnValue;
    }

    @Override
    public <K, V> void put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values not supported");
        }
        this.purgeItems();
        if (this.cache.put(key, new Entry(key, value)) != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryUpdated(key, value);
            }
        } else {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryCreated(key, value);
            }
        }
    }

    @Override
    public <K, V> boolean putIfAbsent(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values not supported");
        }
        this.purgeItems();
        if (this.cache.putIfAbsent(key, new Entry(key, value)) == null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryCreated(key, value);
            }
            return true;
        }
        return false;
    }

    @Override
    public <K> boolean remove(K key) {
        if (this.cache.remove(key) != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRemoved(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public <K> boolean containsKey(K key) {
        Assert.nonNull(key, () -> "Key may not be null");
        this.purgeItems();
        Reference entry = (Reference)this.cache.get(key);
        return entry != null && entry.get() != null;
    }

    private void purgeItems() {
        Entry purgedEntry;
        while ((purgedEntry = (Entry)this.referenceQueue.poll()) != null) {
            if (this.cache.remove(purgedEntry.getKey()) == null) continue;
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryExpired(purgedEntry.getKey());
            }
        }
    }

    private class Entry
    extends WeakReference<Object> {
        private final Object key;

        public Entry(Object key, Object value) {
            super(value, WeakReferenceCache.this.referenceQueue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

