/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class MessageOriginProvider
implements CorrelationDataProvider {
    private static final String DEFAULT_CORRELATION_KEY = "correlationId";
    private static final String DEFAULT_TRACE_KEY = "traceId";
    private final String correlationKey;
    private final String traceKey;

    public static String getDefaultCorrelationKey() {
        return DEFAULT_CORRELATION_KEY;
    }

    public static String getDefaultTraceKey() {
        return DEFAULT_TRACE_KEY;
    }

    public MessageOriginProvider() {
        this(DEFAULT_CORRELATION_KEY, DEFAULT_TRACE_KEY);
    }

    public MessageOriginProvider(String correlationKey, String traceKey) {
        this.correlationKey = correlationKey;
        this.traceKey = traceKey;
    }

    @Override
    public Map<String, ?> correlationDataFor(Message<?> message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.correlationKey, message.getIdentifier());
        result.put(this.traceKey, message.getMetaData().getOrDefault(this.traceKey, message.getIdentifier()));
        return result;
    }
}

