/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;

@MappedSuperclass
public abstract class AbstractEventEntry<T>
implements EventData<T> {
    @Column(nullable=false, unique=true)
    private String eventIdentifier;
    @Basic(optional=false)
    private String timeStamp;
    @Basic(optional=false)
    private String payloadType;
    @Basic
    private String payloadRevision;
    @Basic(optional=false)
    @Lob
    @Column(length=10000)
    private T payload;
    @Basic
    @Lob
    @Column(length=10000)
    private T metaData;

    public AbstractEventEntry(EventMessage<?> eventMessage, Serializer serializer, Class<T> contentType) {
        SerializedObject<T> payload = eventMessage.serializePayload(serializer, contentType);
        SerializedObject<T> metaData = eventMessage.serializeMetaData(serializer, contentType);
        this.eventIdentifier = eventMessage.getIdentifier();
        this.payloadType = payload.getType().getName();
        this.payloadRevision = payload.getType().getRevision();
        this.payload = payload.getData();
        this.metaData = metaData.getData();
        this.timeStamp = DateTimeUtils.formatInstant(eventMessage.getTimestamp());
    }

    public AbstractEventEntry(String eventIdentifier, Object timestamp, String payloadType, String payloadRevision, T payload, T metaData) {
        this.eventIdentifier = eventIdentifier;
        this.timeStamp = timestamp instanceof TemporalAccessor ? DateTimeUtils.formatInstant((TemporalAccessor)timestamp) : timestamp.toString();
        this.payloadType = payloadType;
        this.payloadRevision = payloadRevision;
        this.payload = payload;
        this.metaData = metaData;
    }

    protected AbstractEventEntry() {
    }

    @Override
    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    @Override
    public Instant getTimestamp() {
        return DateTimeUtils.parseInstant(this.timeStamp);
    }

    @Override
    public SerializedObject<T> getMetaData() {
        return new SerializedMetaData<T>(this.metaData, this.metaData.getClass());
    }

    @Override
    public SerializedObject<T> getPayload() {
        return new SimpleSerializedObject<T>(this.payload, this.payload.getClass(), new SimpleSerializedType(this.payloadType, this.payloadRevision));
    }
}

