/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface SubscriptionQueryResult<I, U>
extends Registration {
    public static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Mono<I> initialResult();

    public Flux<U> updates();

    @Deprecated
    default public void handle(Consumer<? super I> initialResultConsumer, Consumer<? super U> updateConsumer) {
        this.handle(initialResultConsumer, updateConsumer, error -> logger.warn("Failed handle the initial result or an update", error));
    }

    default public void handle(Consumer<? super I> initialResultConsumer, Consumer<? super U> updateConsumer, Consumer<Throwable> errorConsumer) {
        this.initialResult().subscribe(initialResult -> {
            try {
                initialResultConsumer.accept((I)initialResult);
                this.updates().subscribe(update -> {
                    try {
                        updateConsumer.accept((U)update);
                    }
                    catch (Exception e) {
                        this.cancel();
                        errorConsumer.accept(e);
                    }
                }, throwable -> {
                    this.cancel();
                    errorConsumer.accept((Throwable)throwable);
                });
            }
            catch (Exception e) {
                this.cancel();
                errorConsumer.accept(e);
            }
        }, throwable -> {
            this.cancel();
            errorConsumer.accept((Throwable)throwable);
        });
    }
}

