/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.axonframework.updates.api.Artifact;

public class UpdateCheckRequest {
    private final String machineId;
    private final String instanceId;
    private final String osName;
    private final String osVersion;
    private final String osArch;
    private final String jvmVersion;
    private final String jvmVendor;
    private final String kotlinVersion;
    private final List<Artifact> libraries;

    public UpdateCheckRequest(String machineId, String instanceId, String osName, String osVersion, String osArch, String jvmVersion, String jvmVendor, String kotlinVersion, List<Artifact> libraries) {
        this.machineId = machineId;
        this.instanceId = instanceId;
        this.osName = osName;
        this.osVersion = osVersion;
        this.osArch = osArch;
        this.jvmVersion = jvmVersion;
        this.jvmVendor = jvmVendor;
        this.kotlinVersion = kotlinVersion;
        this.libraries = libraries;
    }

    public String machineId() {
        return this.machineId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String osName() {
        return this.osName;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public String osArch() {
        return this.osArch;
    }

    public String jvmVersion() {
        return this.jvmVersion;
    }

    public String jvmVendor() {
        return this.jvmVendor;
    }

    public String kotlinVersion() {
        return this.kotlinVersion;
    }

    public List<Artifact> libraries() {
        return this.libraries;
    }

    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("os=").append(this.encode(this.osName + "; " + this.osVersion + "; " + this.osArch)).append("&java=").append(this.encode(this.jvmVersion + "; " + this.jvmVendor)).append("&kotlin=").append(this.encode(this.kotlinVersion));
        for (Artifact library : this.libraries) {
            sb.append("&lib-").append(library.shortGroupId()).append(".").append(library.artifactId()).append("=").append(this.encode(library.version()));
        }
        return sb.toString();
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to encode [" + value + "] to an URL.", e);
        }
    }

    public String toUserAgent() {
        String axonBaseVersion = this.getAxonBaseVersion();
        return String.format("AxonIQ UpdateChecker/%s (Java %s %s; %s; %s; %s)", axonBaseVersion, this.jvmVersion, this.jvmVendor, this.osName, this.osVersion, this.osArch);
    }

    private String getAxonBaseVersion() {
        return this.libraries.stream().filter(a -> a.groupId().equals("org.axonframework")).filter(a -> a.artifactId().equals("axon-messaging")).map(Artifact::version).findFirst().orElse("5.0.0");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCheckRequest that = (UpdateCheckRequest)o;
        return Objects.equals(this.machineId, that.machineId) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.osName, that.osName) && Objects.equals(this.osVersion, that.osVersion) && Objects.equals(this.osArch, that.osArch) && Objects.equals(this.jvmVersion, that.jvmVersion) && Objects.equals(this.jvmVendor, that.jvmVendor) && Objects.equals(this.kotlinVersion, that.kotlinVersion) && Objects.equals(this.libraries, that.libraries);
    }

    public int hashCode() {
        return Objects.hash(this.machineId, this.instanceId, this.osName, this.osVersion, this.osArch, this.jvmVersion, this.jvmVendor, this.kotlinVersion, this.libraries);
    }

    public String toString() {
        return "UpdateCheckRequest{machineId='" + this.machineId + '\'' + ", instanceId='" + this.instanceId + '\'' + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", osArch='" + this.osArch + '\'' + ", jvmVersion='" + this.jvmVersion + '\'' + ", jvmVendor='" + this.jvmVendor + '\'' + ", kotlinVersion='" + this.kotlinVersion + '\'' + ", libraries=" + this.libraries + '}';
    }
}

