/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.axonframework.serialization.avro.AvroUtil;

public interface SchemaIncompatibilityChecker {
    default public void assertSchemaCompatibility(@Nonnull Class<?> readerType, @Nonnull Schema readerSchema, @Nonnull Schema writerSchema, boolean includeSchemasInStackTraces) {
        List<SchemaCompatibility.Incompatibility> incompatibilities = this.checkCompatibility(readerSchema, writerSchema);
        if (!incompatibilities.isEmpty()) {
            String incompatibilitiesMessage = incompatibilities.stream().map(AvroUtil::incompatibilityPrinter).collect(Collectors.joining(", "));
            throw AvroUtil.createExceptionFailedToDeserialize(readerType, readerSchema, writerSchema, "[" + incompatibilitiesMessage + "]", includeSchemasInStackTraces);
        }
    }

    @Nonnull
    default public List<SchemaCompatibility.Incompatibility> checkCompatibility(@Nonnull Schema readerSchema, @Nonnull Schema writerSchema) {
        return AvroUtil.checkCompatibility(readerSchema, writerSchema);
    }
}

