/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.MergedTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.CoordinatorTask;
import org.axonframework.eventhandling.pooled.WorkPackage;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeTask
extends CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final int segmentId;
    private final Map<Integer, WorkPackage> workPackages;
    private final TokenStore tokenStore;
    private final TransactionManager transactionManager;

    MergeTask(CompletableFuture<Boolean> result, String name, int segmentId, Map<Integer, WorkPackage> workPackages, TokenStore tokenStore, TransactionManager transactionManager) {
        super(result, name);
        this.name = name;
        this.segmentId = segmentId;
        this.workPackages = workPackages;
        this.transactionManager = transactionManager;
        this.tokenStore = tokenStore;
    }

    @Override
    protected CompletableFuture<Boolean> task() {
        logger.debug("Processor [{}] will perform merge instruction for segment {}.", (Object)this.name, (Object)this.segmentId);
        int[] segments = this.transactionManager.fetchInTransaction(() -> this.tokenStore.fetchSegments(this.name));
        Segment thisSegment = Segment.computeSegment(this.segmentId, segments);
        int thatSegmentId = thisSegment.mergeableSegmentId();
        Segment thatSegment = Segment.computeSegment(thatSegmentId, segments);
        if (this.segmentId == thatSegmentId) {
            logger.debug("Processor [{}] cannot merge segment {}. A merge request can only be fulfilled if there is more than one segment.", (Object)this.name, (Object)this.segmentId);
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<TrackingToken> thisTokenFuture = this.tokenFor(thisSegment.getSegmentId());
        CompletableFuture<TrackingToken> thatTokenFuture = this.tokenFor(thatSegment.getSegmentId());
        return thisTokenFuture.thenCombine(thatTokenFuture, (thisToken, thatToken) -> this.mergeSegments(thisSegment, (TrackingToken)thisToken, thatSegment, (TrackingToken)thatToken));
    }

    private CompletableFuture<TrackingToken> tokenFor(int segmentId) {
        return this.workPackages.containsKey(segmentId) ? this.workPackages.remove(segmentId).abort(null).thenApply(e -> this.fetchTokenInTransaction(segmentId)) : CompletableFuture.completedFuture(this.fetchTokenInTransaction(segmentId));
    }

    private TrackingToken fetchTokenInTransaction(int segmentId) {
        return this.transactionManager.fetchInTransaction(() -> this.tokenStore.fetchToken(this.name, segmentId));
    }

    private Boolean mergeSegments(Segment thisSegment, TrackingToken thisToken, Segment thatSegment, TrackingToken thatToken) {
        Segment mergedSegment = thisSegment.mergedWith(thatSegment);
        int tokenToDelete = mergedSegment.getSegmentId() == thisSegment.getSegmentId() ? thatSegment.getSegmentId() : thisSegment.getSegmentId();
        TrackingToken mergedToken = thatSegment.getSegmentId() < thisSegment.getSegmentId() ? MergedTrackingToken.merged(thatToken, thisToken) : MergedTrackingToken.merged(thisToken, thatToken);
        this.transactionManager.executeInTransaction(() -> {
            this.tokenStore.deleteToken(this.name, tokenToDelete);
            this.tokenStore.storeToken(mergedToken, this.name, mergedSegment.getSegmentId());
            this.tokenStore.releaseClaim(this.name, mergedSegment.getSegmentId());
        });
        logger.info("Processor [{}] successfully merged {} with {} into {}.", new Object[]{this.name, thisSegment, thatSegment, mergedSegment});
        return true;
    }

    @Override
    String getDescription() {
        return "Merge Task for segment " + this.segmentId;
    }
}

