/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureLoggingCallback<C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<C, R> delegate;
    private final Logger logger;

    public FailureLoggingCallback(Logger logger) {
        this.logger = logger;
        this.delegate = null;
    }

    @Deprecated
    public FailureLoggingCallback(CommandCallback<C, R> delegate) {
        this(LoggerFactory.getLogger(FailureLoggingCallback.class), delegate);
    }

    @Deprecated
    public FailureLoggingCallback(@Nonnull Logger logger, @Nonnull CommandCallback<C, R> delegate) {
        this.logger = logger;
        this.delegate = delegate;
    }

    @Override
    public void onResult(@Nonnull CommandMessage<? extends C> commandMessage, @Nonnull CommandResultMessage<? extends R> commandResultMessage) {
        commandResultMessage.optionalExceptionResult().ifPresent(cause -> this.logger.warn("Command '{}' resulted in {}({})", new Object[]{commandMessage.getCommandName(), cause.getClass().getName(), cause.getMessage()}));
        if (this.delegate != null) {
            this.delegate.onResult(commandMessage, commandResultMessage);
        }
    }
}

