/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageEncoder;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.avro.AvroUtil;

public class GenericRecordToByteArrayConverter
implements ContentTypeConverter<GenericRecord, byte[]> {
    @Override
    public Class<GenericRecord> expectedSourceType() {
        return GenericRecord.class;
    }

    @Override
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] convert(GenericRecord genericRecord) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new BinaryMessageEncoder(AvroUtil.genericData, genericRecord.getSchema()).encode((Object)genericRecord, (OutputStream)baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CannotConvertBetweenTypesException("Cannot convert GenericRecord to bytes", e);
        }
    }
}

