/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;

public class GenericQueryMessage<T, R>
extends MessageDecorator<T>
implements QueryMessage<T, R> {
    private static final long serialVersionUID = -3908412412867063631L;
    private final String queryName;
    private final ResponseType<R> responseType;

    public GenericQueryMessage(T payload, ResponseType<R> responseType) {
        this(payload, payload.getClass().getName(), responseType);
    }

    public GenericQueryMessage(T payload, String queryName, ResponseType<R> responseType) {
        this(new GenericMessage<T>(payload, MetaData.emptyInstance()), queryName, responseType);
    }

    public GenericQueryMessage(Message<T> delegate, String queryName, ResponseType<R> responseType) {
        super(delegate);
        this.responseType = responseType;
        this.queryName = queryName;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public ResponseType<R> getResponseType() {
        return this.responseType;
    }

    @Override
    public QueryMessage<T, R> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericQueryMessage(this.getDelegate().withMetaData(metaData), this.queryName, this.responseType);
    }

    @Override
    public QueryMessage<T, R> andMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericQueryMessage(this.getDelegate().andMetaData(metaData), this.queryName, this.responseType);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", queryName='").append(this.getQueryName()).append('\'').append(", expectedResponseType='").append(this.getResponseType()).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericQueryMessage";
    }
}

