/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public abstract class CurrentUnitOfWork {
    private static final ThreadLocal<Deque<UnitOfWork<?>>> CURRENT = new ThreadLocal();

    public static boolean isStarted() {
        return CURRENT.get() != null && !CURRENT.get().isEmpty();
    }

    public static boolean ifStarted(Consumer<UnitOfWork<?>> consumer) {
        if (CurrentUnitOfWork.isStarted()) {
            consumer.accept(CurrentUnitOfWork.get());
            return true;
        }
        return false;
    }

    public static <T> Optional<T> map(Function<UnitOfWork<?>, T> function) {
        return CurrentUnitOfWork.isStarted() ? Optional.ofNullable(function.apply(CurrentUnitOfWork.get())) : Optional.empty();
    }

    public static UnitOfWork<?> get() {
        if (CurrentUnitOfWork.isEmpty()) {
            throw new IllegalStateException("No UnitOfWork is currently started for this thread.");
        }
        return CURRENT.get().peek();
    }

    private static boolean isEmpty() {
        Deque<UnitOfWork<?>> unitsOfWork = CURRENT.get();
        return unitsOfWork == null || unitsOfWork.isEmpty();
    }

    public static void commit() {
        CurrentUnitOfWork.get().commit();
    }

    public static void set(UnitOfWork<?> unitOfWork) {
        if (CURRENT.get() == null) {
            CURRENT.set(new LinkedList());
        }
        CURRENT.get().push(unitOfWork);
    }

    public static void clear(UnitOfWork<?> unitOfWork) {
        if (!CurrentUnitOfWork.isStarted()) {
            throw new IllegalStateException("Could not clear this UnitOfWork. There is no UnitOfWork active.");
        }
        if (CURRENT.get().peek() == unitOfWork) {
            CURRENT.get().pop();
            if (CURRENT.get().isEmpty()) {
                CURRENT.remove();
            }
        } else {
            throw new IllegalStateException("Could not clear this UnitOfWork. It is not the active one.");
        }
    }

    public static MetaData correlationData() {
        return CurrentUnitOfWork.map(UnitOfWork::getCorrelationData).orElse(MetaData.emptyInstance());
    }

    private CurrentUnitOfWork() {
    }
}

