/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.PayloadParameterResolver;

@Priority(value=-1073741824)
public class DefaultParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        Class<Object> payloadType;
        Class<?> parameterType = parameters[parameterIndex].getType();
        if (Message.class.isAssignableFrom(parameterType)) {
            return new MessageParameterResolver(parameterType);
        }
        Optional<Map<String, Object>> metaDataValueAnnotation = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameters[parameterIndex], MetaDataValue.class);
        if (metaDataValueAnnotation.isPresent()) {
            return new AnnotatedMetaDataParameterResolver(metaDataValueAnnotation.get(), parameterType);
        }
        if (MetaData.class.isAssignableFrom(parameterType)) {
            return MetaDataParameterResolver.INSTANCE;
        }
        if (parameterIndex == 0 && (payloadType = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)executable, MessageHandler.class).map(attr -> attr.get("payloadType")).orElse(Object.class)).isAssignableFrom(parameterType)) {
            return new PayloadParameterResolver(parameterType);
        }
        return null;
    }

    private static class MessageParameterResolver
    implements ParameterResolver {
        private final Class<?> parameterType;

        public MessageParameterResolver(Class<?> parameterType) {
            this.parameterType = parameterType;
        }

        public Object resolveParameterValue(Message message) {
            return message;
        }

        public boolean matches(Message message) {
            return this.parameterType.isInstance(message);
        }
    }

    private static final class MetaDataParameterResolver
    implements ParameterResolver {
        private static final MetaDataParameterResolver INSTANCE = new MetaDataParameterResolver();

        private MetaDataParameterResolver() {
        }

        public Object resolveParameterValue(Message message) {
            return message.getMetaData();
        }

        public boolean matches(Message message) {
            return true;
        }
    }

    private static class AnnotatedMetaDataParameterResolver
    implements ParameterResolver<Object> {
        private static final String REQUIRED_PROPERTY = "required";
        private static final String META_DATA_VALUE_PROPERTY = "metaDataValue";
        private final Map<String, Object> metaDataValue;
        private final Class parameterType;

        public AnnotatedMetaDataParameterResolver(Map<String, Object> metaDataValue, Class parameterType) {
            this.metaDataValue = metaDataValue;
            this.parameterType = parameterType;
        }

        @Override
        public Object resolveParameterValue(Message<?> message) {
            return message.getMetaData().get(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString());
        }

        @Override
        public boolean matches(Message<?> message) {
            return !this.parameterType.isPrimitive() && (Boolean)this.metaDataValue.get(REQUIRED_PROPERTY) == false || message.getMetaData().containsKey(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString()) && this.parameterType.isInstance(message.getMetaData().get(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString()));
        }
    }
}

