/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.axonframework.common.ProcessRetriesExhaustedException;

public abstract class ProcessUtils {
    private ProcessUtils() {
    }

    public static void executeWithRetry(Runnable runnable, Predicate<RuntimeException> retryPredicate, long timeout, TimeUnit timeUnit, long retryInterval) {
        long completeBefore = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        RuntimeException lastException = new RuntimeException();
        while (completeBefore > System.currentTimeMillis()) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException re) {
                if (!retryPredicate.test(re)) {
                    throw re;
                }
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw re;
                }
                lastException = re;
            }
        }
        throw lastException;
    }

    public static void executeUntilTrue(BooleanSupplier runnable, long retryInterval, long maxTries) {
        AtomicLong totalTriesCounter = new AtomicLong();
        boolean result = runnable.getAsBoolean();
        while (!result) {
            if (totalTriesCounter.incrementAndGet() >= maxTries) {
                throw new ProcessRetriesExhaustedException(String.format("Tried invoking the action for %d times, without the result being true", maxTries));
            }
            try {
                Thread.sleep(retryInterval);
                result = runnable.getAsBoolean();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

