/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.quartz.EventJobDataBinder;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireEventJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(FireEventJob.class);
    public static final String EVENT_JOB_DATA_BINDER_KEY = EventJobDataBinder.class.getName();
    public static final String EVENT_BUS_KEY = EventBus.class.getName();
    public static final String TRANSACTION_MANAGER_KEY = TransactionManager.class.getName();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting job to publish a scheduled event");
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobData = jobDetail.getJobDataMap();
        try {
            SchedulerContext schedulerContext = context.getScheduler().getContext();
            EventJobDataBinder jobDataBinder = (EventJobDataBinder)schedulerContext.get((Object)EVENT_JOB_DATA_BINDER_KEY);
            Object event = jobDataBinder.fromJobData(jobData);
            EventMessage<?> eventMessage = this.createMessage(event);
            EventBus eventBus = (EventBus)context.getScheduler().getContext().get((Object)EVENT_BUS_KEY);
            TransactionManager txManager = (TransactionManager)context.getScheduler().getContext().get((Object)TRANSACTION_MANAGER_KEY);
            DefaultUnitOfWork<Object> unitOfWork = DefaultUnitOfWork.startAndGet(null);
            if (txManager != null) {
                unitOfWork.attachTransaction(txManager);
            }
            unitOfWork.execute(() -> eventBus.publish(eventMessage));
            if (logger.isInfoEnabled()) {
                logger.info("Job successfully executed. Scheduled Event [{}] has been published.", (Object)eventMessage.getPayloadType().getSimpleName());
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while publishing scheduled event [{}]", (Object)jobDetail.getDescription(), (Object)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    private EventMessage<?> createMessage(Object event) {
        GenericEventMessage<Object> eventMessage = event instanceof EventMessage ? new GenericEventMessage(((EventMessage)event).getPayload(), ((EventMessage)event).getMetaData()) : new GenericEventMessage<Object>(event, MetaData.emptyInstance());
        return eventMessage;
    }
}

