/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.transaction.TransactionManager;

public class PagingJdbcIterable<R>
implements Iterable<R> {
    private final int pageSize;
    private final Supplier<Connection> connectionProvider;
    private final TransactionManager transactionManager;
    private final PagingStatementSupplier pagingQuerySupplier;
    private final JdbcUtils.SqlResultConverter<R> resultConverter;
    private final Function<SQLException, RuntimeException> errorHandler;

    public PagingJdbcIterable(TransactionManager transactionManager, Supplier<Connection> connectionProvider, PagingStatementSupplier pagingQuerySupplier, int pageSize, JdbcUtils.SqlResultConverter<R> resultConverter, Function<SQLException, RuntimeException> errorHandler) {
        this.transactionManager = transactionManager;
        this.connectionProvider = connectionProvider;
        this.pagingQuerySupplier = pagingQuerySupplier;
        this.pageSize = pageSize;
        this.resultConverter = resultConverter;
        this.errorHandler = errorHandler;
    }

    @Override
    public Iterator<R> iterator() {
        return new PagingIterator();
    }

    @FunctionalInterface
    public static interface PagingStatementSupplier {
        public PreparedStatement apply(Connection var1, int var2, int var3) throws SQLException;
    }

    public class PagingIterator
    implements Iterator<R> {
        private Deque<R> currentPage = new ArrayDeque();
        private int page = 0;

        @Override
        public boolean hasNext() {
            this.refreshPageIfNecessary();
            return !this.currentPage.isEmpty();
        }

        @Override
        public R next() {
            this.refreshPageIfNecessary();
            Object row = this.currentPage.pop();
            if (row == null) {
                throw new NoSuchElementException();
            }
            return row;
        }

        private void refreshPageIfNecessary() {
            if (!this.currentPage.isEmpty()) {
                return;
            }
            List results = PagingJdbcIterable.this.transactionManager.fetchInTransaction(() -> JdbcUtils.executeQuery((Connection)PagingJdbcIterable.this.connectionProvider.get(), connection -> PagingJdbcIterable.this.pagingQuerySupplier.apply(connection, this.page * PagingJdbcIterable.this.pageSize, PagingJdbcIterable.this.pageSize), JdbcUtils.listResults(PagingJdbcIterable.this.resultConverter), PagingJdbcIterable.this.errorHandler));
            this.currentPage = new ArrayDeque(results);
            ++this.page;
        }
    }
}

