/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;

public interface UnitOfWork<T extends Message<?>> {
    public void start();

    public void commit();

    default public void rollback() {
        this.rollback(null);
    }

    public void rollback(Throwable var1);

    default public boolean isActive() {
        return this.phase().isStarted();
    }

    public Phase phase();

    public void onPrepareCommit(Consumer<UnitOfWork<T>> var1);

    public void onCommit(Consumer<UnitOfWork<T>> var1);

    public void afterCommit(Consumer<UnitOfWork<T>> var1);

    public void onRollback(Consumer<UnitOfWork<T>> var1);

    public void onCleanup(Consumer<UnitOfWork<T>> var1);

    public Optional<UnitOfWork<?>> parent();

    default public boolean isRoot() {
        return !this.parent().isPresent();
    }

    default public UnitOfWork<?> root() {
        return this.parent().map(UnitOfWork::root).orElse(this);
    }

    public T getMessage();

    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> var1);

    public MetaData getCorrelationData();

    public void registerCorrelationDataProvider(CorrelationDataProvider var1);

    public Map<String, Object> resources();

    default public <R> R getResource(String name) {
        return (R)this.resources().get(name);
    }

    default public <R> R getOrComputeResource(String key, Function<? super String, R> mappingFunction) {
        return (R)this.resources().computeIfAbsent(key, mappingFunction);
    }

    default public <R> R getOrDefaultResource(String key, R defaultValue) {
        return (R)this.resources().getOrDefault(key, defaultValue);
    }

    default public void attachTransaction(TransactionManager transactionManager) {
        try {
            Transaction transaction = transactionManager.startTransaction();
            this.onCommit(u -> transaction.commit());
            this.onRollback(u -> transaction.rollback());
        }
        catch (Throwable t) {
            this.rollback(t);
            throw t;
        }
    }

    default public void execute(Runnable task) {
        this.execute(task, RollbackConfigurationType.ANY_THROWABLE);
    }

    default public void execute(Runnable task, RollbackConfiguration rollbackConfiguration) {
        ResultMessage<Object> resultMessage = this.executeWithResult(() -> {
            task.run();
            return null;
        }, rollbackConfiguration);
        if (resultMessage.isExceptional()) {
            throw (RuntimeException)resultMessage.exceptionResult();
        }
    }

    default public <R> ResultMessage<R> executeWithResult(Callable<R> task) {
        return this.executeWithResult(task, RollbackConfigurationType.ANY_THROWABLE);
    }

    public <R> ResultMessage<R> executeWithResult(Callable<R> var1, @Nonnull RollbackConfiguration var2);

    public ExecutionResult getExecutionResult();

    public boolean isRolledBack();

    default public boolean isCurrent() {
        return CurrentUnitOfWork.isStarted() && CurrentUnitOfWork.get() == this;
    }

    public static enum Phase {
        NOT_STARTED(false, false, false),
        STARTED(true, false, false),
        PREPARE_COMMIT(true, false, false),
        COMMIT(true, true, false),
        ROLLBACK(true, true, true),
        AFTER_COMMIT(true, true, true),
        CLEANUP(false, true, true),
        CLOSED(false, true, true);

        private final boolean started;
        private final boolean reverseCallbackOrder;
        private final boolean suppressHandlerErrors;

        private Phase(boolean started, boolean reverseCallbackOrder, boolean suppressHandlerErrors) {
            this.started = started;
            this.reverseCallbackOrder = reverseCallbackOrder;
            this.suppressHandlerErrors = suppressHandlerErrors;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isReverseCallbackOrder() {
            return this.reverseCallbackOrder;
        }

        public boolean isSuppressHandlerErrors() {
            return this.suppressHandlerErrors;
        }

        public boolean isBefore(Phase phase) {
            return this.ordinal() < phase.ordinal();
        }

        public boolean isAfter(Phase phase) {
            return this.ordinal() > phase.ordinal();
        }
    }
}

