/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;

public class HandlerTypeResolver {
    public static boolean isCommandHandler(Class<?> handlerClass) {
        return HandlerTypeResolver.isHandlerOfType(handlerClass, CommandHandler.class);
    }

    public static boolean isEventHandler(Class<?> handlerClass) {
        return HandlerTypeResolver.isHandlerOfType(handlerClass, EventHandler.class);
    }

    public static boolean isQueryHandler(Class<?> handlerClass) {
        return HandlerTypeResolver.isHandlerOfType(handlerClass, QueryHandler.class);
    }

    private static boolean isHandlerOfType(Class<?> handlerClass, Class<? extends Annotation> annotationType) {
        for (Method m : ReflectionUtils.methodsOf(handlerClass)) {
            if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)m, annotationType)) continue;
            return true;
        }
        return false;
    }

    private HandlerTypeResolver() {
    }
}

