/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;

@Deprecated
public class NestingSpanFactory
implements SpanFactory {
    private final SpanFactory delegateSpanFactory;
    private final Duration timeLimit;
    private final Clock clock;

    protected NestingSpanFactory(Builder builder) {
        builder.validate();
        this.delegateSpanFactory = builder.delegateSpanFactory;
        this.timeLimit = builder.timeLimit;
        this.clock = builder.clock;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        return this.delegateSpanFactory.createRootTrace(operationNameSupplier);
    }

    @Override
    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        boolean isLinkedTrace;
        boolean bl = isLinkedTrace = !isChildTrace;
        if (isLinkedTrace && this.messageShouldBeForcedToNest(parentMessage)) {
            return this.delegateSpanFactory.createHandlerSpan(operationNameSupplier, parentMessage, true, linkedParents);
        }
        return this.delegateSpanFactory.createHandlerSpan(operationNameSupplier, parentMessage, isChildTrace, linkedParents);
    }

    private boolean messageShouldBeForcedToNest(Message<?> parentMessage) {
        if (parentMessage instanceof EventMessage) {
            Instant timestamp = ((EventMessage)parentMessage).getTimestamp();
            return this.clock.instant().isBefore(timestamp.plus(this.timeLimit));
        }
        return true;
    }

    @Override
    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        return this.delegateSpanFactory.createDispatchSpan(operationNameSupplier, parentMessage, linkedSiblings);
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        return this.delegateSpanFactory.createInternalSpan(operationNameSupplier);
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        return this.delegateSpanFactory.createInternalSpan(operationNameSupplier, message);
    }

    @Override
    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
        this.delegateSpanFactory.registerSpanAttributeProvider(provider);
    }

    @Override
    public <M extends Message<?>> M propagateContext(M message) {
        return this.delegateSpanFactory.propagateContext(message);
    }

    public static class Builder {
        private SpanFactory delegateSpanFactory;
        private Duration timeLimit = Duration.ofMinutes(2L);
        private Clock clock = Clock.systemUTC();

        public Builder delegate(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "The spanFactory should not be null");
            this.delegateSpanFactory = spanFactory;
            return this;
        }

        public Builder timeLimit(@Nonnull Duration timeLimit) {
            BuilderUtils.assertNonNull(timeLimit, "The timeLimit should not be null");
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder clock(@Nonnull Clock clock) {
            BuilderUtils.assertNonNull(clock, "The clock should not be null");
            this.clock = clock;
            return this;
        }

        public NestingSpanFactory build() {
            return new NestingSpanFactory(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.delegateSpanFactory, "The delegateSpanFactory should be configured");
        }
    }
}

