/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;

public class MultiSpanFactory
implements SpanFactory {
    private final List<SpanFactory> spanFactories;

    public MultiSpanFactory(List<SpanFactory> spanFactories) {
        this.spanFactories = spanFactories;
    }

    @Override
    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        return new MultiSpan(this.spanFactories.stream().map(sf -> sf.createRootTrace(operationNameSupplier)).collect(Collectors.toList()));
    }

    @Override
    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        return new MultiSpan(this.spanFactories.stream().map(sf -> sf.createHandlerSpan(operationNameSupplier, parentMessage, isChildTrace, linkedParents)).collect(Collectors.toList()));
    }

    @Override
    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        return new MultiSpan(this.spanFactories.stream().map(sf -> sf.createDispatchSpan(operationNameSupplier, parentMessage, linkedSiblings)).collect(Collectors.toList()));
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        return new MultiSpan(this.spanFactories.stream().map(sf -> sf.createInternalSpan(operationNameSupplier)).collect(Collectors.toList()));
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        return new MultiSpan(this.spanFactories.stream().map(sf -> sf.createInternalSpan(operationNameSupplier, message)).collect(Collectors.toList()));
    }

    @Override
    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
        this.spanFactories.forEach(sf -> sf.registerSpanAttributeProvider(provider));
    }

    @Override
    public <M extends Message<?>> M propagateContext(M message) {
        M adjustedMessage = message;
        for (SpanFactory spanFactory : this.spanFactories) {
            adjustedMessage = spanFactory.propagateContext(adjustedMessage);
        }
        return adjustedMessage;
    }

    private static class MultiSpan
    implements Span {
        private final List<Span> spans;

        public MultiSpan(List<Span> spans) {
            this.spans = spans;
        }

        @Override
        public Span start() {
            this.spans.forEach(Span::start);
            return this;
        }

        @Override
        public SpanScope makeCurrent() {
            List scopes = this.spans.stream().map(Span::makeCurrent).collect(Collectors.toList());
            return () -> scopes.forEach(SpanScope::close);
        }

        @Override
        public void end() {
            this.spans.forEach(Span::end);
        }

        @Override
        public Span recordException(Throwable t) {
            this.spans.forEach(s -> s.recordException(t));
            return this;
        }

        @Override
        public Span addAttribute(String key, String value) {
            this.spans.forEach(s -> s.addAttribute(key, value));
            return this;
        }
    }
}

