/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedType;

public class SimpleSerializedObject<T>
implements SerializedObject<T> {
    private final T data;
    private final SerializedType type;
    private final Class<T> dataType;

    public SimpleSerializedObject(T data, Class<T> dataType, SerializedType serializedType) {
        Assert.notNull(data, () -> "Data for a serialized object cannot be null");
        Assert.notNull(serializedType, () -> "The type identifier of the serialized object");
        this.data = data;
        this.dataType = dataType;
        this.type = serializedType;
    }

    public SimpleSerializedObject(T data, Class<T> dataType, String type, String revision) {
        this(data, dataType, new SimpleSerializedType(type, revision));
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public Class<T> getContentType() {
        return this.dataType;
    }

    @Override
    public SerializedType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSerializedObject that = (SimpleSerializedObject)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.type, that.type) && Objects.equals(this.dataType, that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.type, this.dataType);
    }

    public String toString() {
        return String.format("SimpleSerializedObject [%s]", this.type);
    }
}

