/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;

public interface MessageMonitor<T extends Message<?>> {
    public MonitorCallback onMessageIngested(@Nonnull T var1);

    default public Map<? super T, MonitorCallback> onMessagesIngested(@Nonnull Collection<? extends T> messages) {
        return messages.stream().collect(Collectors.toMap(msg -> msg, this::onMessageIngested));
    }

    public static interface MonitorCallback {
        public void reportSuccess();

        public void reportFailure(Throwable var1);

        public void reportIgnored();
    }
}

