/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.common.Assert;
import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.AbstractUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.MessageProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class DefaultUnitOfWork<T extends Message<?>>
extends AbstractUnitOfWork<T> {
    private final MessageProcessingContext<T> processingContext;

    public static <T extends Message<?>> DefaultUnitOfWork<T> startAndGet(T message) {
        DefaultUnitOfWork<T> uow = new DefaultUnitOfWork<T>(message);
        uow.start();
        return uow;
    }

    public DefaultUnitOfWork(T message) {
        this.processingContext = new MessageProcessingContext<T>(message);
    }

    @Override
    public <R> ResultMessage<R> executeWithResult(Callable<R> task, @Nonnull RollbackConfiguration rollbackConfiguration) {
        ResultMessage<Object> resultMessage;
        block5: {
            if (this.phase() == UnitOfWork.Phase.NOT_STARTED) {
                this.start();
            }
            Assert.state(this.phase() == UnitOfWork.Phase.STARTED, () -> String.format("The UnitOfWork has an incompatible phase: %s", new Object[]{this.phase()}));
            try {
                R result = task.call();
                resultMessage = result instanceof ResultMessage ? (GenericResultMessage<R>)result : (result instanceof Message ? new GenericResultMessage<R>(result, ((Message)result).getMetaData()) : new GenericResultMessage<R>(result));
            }
            catch (Error | Exception e) {
                resultMessage = GenericResultMessage.asResultMessage(e);
                if (!rollbackConfiguration.rollBackOn(e)) break block5;
                this.rollback(e);
                return resultMessage;
            }
        }
        this.setExecutionResult(new ExecutionResult(resultMessage));
        try {
            this.commit();
        }
        catch (Exception e) {
            resultMessage = GenericResultMessage.asResultMessage(e);
        }
        return resultMessage;
    }

    @Override
    protected void setRollbackCause(Throwable cause) {
        this.setExecutionResult(new ExecutionResult(new GenericResultMessage(cause)));
    }

    @Override
    protected void notifyHandlers(UnitOfWork.Phase phase) {
        this.processingContext.notifyHandlers(this, phase);
    }

    @Override
    protected void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        Assert.state(!phase.isBefore(this.phase()), () -> "Cannot register a listener for phase: " + (Object)((Object)phase) + " because the Unit of Work is already in a later phase: " + (Object)((Object)this.phase()));
        this.processingContext.addHandler(phase, handler);
    }

    @Override
    public T getMessage() {
        return this.processingContext.getMessage();
    }

    @Override
    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.processingContext.transformMessage(transformOperator);
        return this;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.processingContext.getExecutionResult();
    }

    @Override
    protected void setExecutionResult(ExecutionResult executionResult) {
        this.processingContext.setExecutionResult(executionResult);
    }
}

