/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.Future;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.responsetypes.AbstractResponseType;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OptionalResponseType<R>
extends AbstractResponseType<Optional<R>> {
    @JsonCreator
    @ConstructorProperties(value={"expectedResponseType"})
    public OptionalResponseType(@JsonProperty(value="expectedResponseType") Class<R> expectedResponseType) {
        super(expectedResponseType);
    }

    @Override
    public boolean matches(Type responseType) {
        Type unwrapped = ReflectionUtils.unwrapIfType(responseType, Future.class, Optional.class);
        return this.isGenericAssignableFrom(unwrapped) || this.isAssignableFrom(unwrapped);
    }

    @Override
    public Optional<R> convert(Object response) {
        if (response instanceof Optional) {
            return (Optional)response;
        }
        if (response != null && this.projectReactorOnClassPath()) {
            if (Mono.class.isAssignableFrom(response.getClass())) {
                return Optional.ofNullable(((Mono)response).block());
            }
            if (Publisher.class.isAssignableFrom(response.getClass())) {
                return Optional.ofNullable(Mono.from((Publisher)((Publisher)response)).block());
            }
        }
        return Optional.ofNullable(this.expectedResponseType.cast(response));
    }

    @Override
    public Class responseMessagePayloadType() {
        return Optional.class;
    }

    @Override
    public ResponseType<?> forSerialization() {
        return ResponseTypes.instanceOf(this.expectedResponseType);
    }

    public String toString() {
        return "OptionalResponseType{" + this.expectedResponseType + "}";
    }
}

