/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetaData
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -7892913866303912970L;
    private static final MetaData EMPTY_META_DATA = new MetaData();
    private static final String UNSUPPORTED_MUTATION_MSG = "Metadata is immutable.";
    private final Map<String, Object> values;

    private MetaData() {
        this.values = Collections.emptyMap();
    }

    public MetaData(@Nonnull Map<String, ?> items) {
        this.values = Collections.unmodifiableMap(new HashMap(items));
    }

    public static MetaData emptyInstance() {
        return EMPTY_META_DATA;
    }

    public static MetaData from(@Nullable Map<String, ?> metaDataEntries) {
        if (metaDataEntries instanceof MetaData) {
            return (MetaData)metaDataEntries;
        }
        if (metaDataEntries == null || metaDataEntries.isEmpty()) {
            return MetaData.emptyInstance();
        }
        return new MetaData(metaDataEntries);
    }

    public static MetaData with(@Nonnull String key, @Nullable Object value) {
        return MetaData.from(Collections.singletonMap(key, value));
    }

    public MetaData and(@Nonnull String key, @Nullable Object value) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(this.values);
        newValues.put(key, value);
        return new MetaData(newValues);
    }

    public MetaData andIfNotPresent(@Nonnull String key, @Nonnull Supplier<Object> value) {
        return this.containsKey(key) ? this : this.and(key, value.get());
    }

    @Override
    public Object get(Object key) {
        return this.values.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ?> m) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.values.equals(that);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public MetaData mergedWith(@Nonnull Map<String, ?> additionalEntries) {
        if (additionalEntries.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return MetaData.from(additionalEntries);
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(this.values);
        merged.putAll(additionalEntries);
        return new MetaData(merged);
    }

    public MetaData withoutKeys(@Nonnull Set<String> keys) {
        if (keys.isEmpty()) {
            return this;
        }
        HashMap<String, Object> modified = new HashMap<String, Object>(this.values);
        keys.forEach(modified::remove);
        return new MetaData(modified);
    }

    public MetaData subset(String ... keys) {
        return MetaData.from(Stream.of(keys).filter(this::containsKey).collect(new MetaDataCollector(this::get)));
    }

    protected Object readResolve() {
        if (this.isEmpty()) {
            return MetaData.emptyInstance();
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.values.forEach((k, v) -> sb.append(", '").append((String)k).append("'->'").append(v).append('\''));
        int skipInitialListingAppendString = 2;
        return this.values.isEmpty() ? sb.toString() : sb.substring(skipInitialListingAppendString);
    }

    private static class MetaDataCollector
    implements Collector<String, Map<String, Object>, MetaData> {
        private final Function<String, Object> valueProvider;

        private MetaDataCollector(Function<String, Object> valueProvider) {
            this.valueProvider = valueProvider;
        }

        @Override
        public Supplier<Map<String, Object>> supplier() {
            return HashMap::new;
        }

        @Override
        public BiConsumer<Map<String, Object>, String> accumulator() {
            return (map, key) -> map.put(key, this.valueProvider.apply((String)key));
        }

        @Override
        public BinaryOperator<Map<String, Object>> combiner() {
            return (m1, m2) -> {
                HashMap result = new HashMap(m1);
                result.putAll(m2);
                return result;
            };
        }

        @Override
        public Function<Map<String, Object>, MetaData> finisher() {
            return MetaData::from;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

