/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class TrackingTokenParameterResolverFactory
implements ParameterResolverFactory {
    private static final TrackingTokenParameterResolver RESOLVER = new TrackingTokenParameterResolver();

    @Override
    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (TrackingToken.class.equals(parameters[parameterIndex].getType())) {
            return RESOLVER;
        }
        return null;
    }

    private static class TrackingTokenParameterResolver
    implements ParameterResolver<TrackingToken> {
        private TrackingTokenParameterResolver() {
        }

        @Override
        public TrackingToken resolveParameterValue(Message<?> message) {
            return this.unwrap(((TrackedEventMessage)message).trackingToken());
        }

        private TrackingToken unwrap(TrackingToken trackingToken) {
            return WrappedToken.unwrapLowerBound(trackingToken);
        }

        @Override
        public boolean matches(Message<?> message) {
            return message instanceof TrackedEventMessage;
        }
    }
}

