/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class SimpleEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<EventMessageHandler> eventHandlingComponents;
    private final ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private final SequencingPolicy<? super EventMessage<?>> sequencingPolicy;

    protected SimpleEventHandlerInvoker(Builder<?> builder) {
        builder.validate();
        this.eventHandlingComponents = ((Builder)builder).eventHandlers.stream().map(handler -> handler instanceof EventMessageHandler ? (EventMessageHandler)handler : builder.wrapEventMessageHandler(handler)).collect(Collectors.toCollection(ArrayList::new));
        this.sequencingPolicy = ((Builder)builder).sequencingPolicy;
        this.listenerInvocationErrorHandler = ((Builder)builder).listenerInvocationErrorHandler;
    }

    private static List<?> detectList(Object[] eventHandlers) {
        return eventHandlers.length == 1 && eventHandlers[0] instanceof List ? (List)eventHandlers[0] : Arrays.asList(eventHandlers);
    }

    public static <B extends Builder<?>> Builder<B> builder() {
        return new Builder();
    }

    public List<EventMessageHandler> eventHandlers() {
        return Collections.unmodifiableList(this.eventHandlingComponents);
    }

    @Override
    public void handle(@Nonnull EventMessage<?> message, @Nonnull Segment segment) throws Exception {
        if (!this.sequencingPolicyMatchesSegment(message, segment)) {
            return;
        }
        this.invokeHandlers(message);
    }

    protected boolean sequencingPolicyMatchesSegment(EventMessage<?> message, Segment segment) {
        return segment.matches(Objects.hashCode(this.sequenceIdentifier(message)));
    }

    protected Object sequenceIdentifier(EventMessage<?> event) {
        return ObjectUtils.getOrDefault(this.sequencingPolicy.getSequenceIdentifierFor(event), event::getIdentifier);
    }

    protected void invokeHandlers(EventMessage<?> message) throws Exception {
        for (EventMessageHandler handler : this.eventHandlingComponents) {
            try {
                handler.handle(message);
            }
            catch (Exception e) {
                this.listenerInvocationErrorHandler.onError(e, message, handler);
            }
        }
    }

    @Override
    public boolean canHandle(@Nonnull EventMessage<?> eventMessage, @Nonnull Segment segment) {
        return this.hasHandler(eventMessage) && this.sequencingPolicyMatchesSegment(eventMessage, segment);
    }

    @Override
    public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return this.eventHandlingComponents.stream().anyMatch(eh -> eh.canHandleType(payloadType));
    }

    private boolean hasHandler(@Nonnull EventMessage<?> eventMessage) {
        for (EventMessageHandler eventHandler : this.eventHandlingComponents) {
            if (!eventHandler.canHandle(eventMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsReset() {
        return this.eventHandlingComponents.stream().anyMatch(EventMessageHandler::supportsReset);
    }

    @Override
    public void performReset() {
        this.performReset(null);
    }

    @Override
    public <R> void performReset(@Nullable R resetContext) {
        for (EventMessageHandler eventHandler : this.eventHandlingComponents) {
            eventHandler.prepareReset(resetContext);
        }
    }

    public ListenerInvocationErrorHandler getListenerInvocationErrorHandler() {
        return this.listenerInvocationErrorHandler;
    }

    public SequencingPolicy<? super EventMessage<?>> getSequencingPolicy() {
        return this.sequencingPolicy;
    }

    public static class Builder<B extends Builder<?>> {
        private List<?> eventHandlers;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private ListenerInvocationErrorHandler listenerInvocationErrorHandler = new LoggingErrorHandler();
        private SequencingPolicy<? super EventMessage<?>> sequencingPolicy = SequentialPerAggregatePolicy.instance();

        public B eventHandlers(Object ... eventHandlers) {
            return this.eventHandlers(SimpleEventHandlerInvoker.detectList(eventHandlers));
        }

        public B eventHandlers(@Nonnull List<?> eventHandlers) {
            BuilderUtils.assertThat(eventHandlers, list -> list != null && !list.isEmpty(), "At least one EventMessageHandler should be provided");
            this.eventHandlers = eventHandlers;
            return (B)this;
        }

        public B parameterResolverFactory(@Nonnull ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull(parameterResolverFactory, "ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return (B)this;
        }

        public B handlerDefinition(@Nonnull HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull(handlerDefinition, "HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return (B)this;
        }

        public B listenerInvocationErrorHandler(@Nonnull ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
            BuilderUtils.assertNonNull(listenerInvocationErrorHandler, "ListenerInvocationErrorHandler may not be null");
            this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
            return (B)this;
        }

        public B sequencingPolicy(@Nonnull SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
            BuilderUtils.assertNonNull(sequencingPolicy, "The SequencingPolicy may not be null");
            this.sequencingPolicy = sequencingPolicy;
            return (B)this;
        }

        public SimpleEventHandlerInvoker build() {
            return new SimpleEventHandlerInvoker(this);
        }

        public AnnotationEventHandlerAdapter wrapEventMessageHandler(@Nonnull Object eventHandler) {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory);
            }
            return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory, this.handlerDefinition);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertThat(this.eventHandlers, list -> list != null && !list.isEmpty(), "At least one EventMessageHandler should be provided");
        }
    }
}

